# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210224

from .update_certificate_authority_action_details import UpdateCertificateAuthorityActionDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateCertificateAuthorityCertificateDetails(UpdateCertificateAuthorityActionDetails):
    """
    The details of the request to update the certificate authority (CA) with a signed certificate for the latest CA version.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateCertificateAuthorityCertificateDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.certificates_management.models.UpdateCertificateAuthorityCertificateDetails.action_type` attribute
        of this class is ``UPDATE_CERTIFICATE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param action_type:
            The value to assign to the action_type property of this UpdateCertificateAuthorityCertificateDetails.
            Allowed values for this property are: "UPDATE_CERTIFICATE", "GENERATE_CSR"
        :type action_type: str

        :param certificate_pem:
            The value to assign to the certificate_pem property of this UpdateCertificateAuthorityCertificateDetails.
        :type certificate_pem: str

        """
        self.swagger_types = {
            'action_type': 'str',
            'certificate_pem': 'str'
        }
        self.attribute_map = {
            'action_type': 'actionType',
            'certificate_pem': 'certificatePem'
        }
        self._action_type = None
        self._certificate_pem = None
        self._action_type = 'UPDATE_CERTIFICATE'

    @property
    def certificate_pem(self):
        """
        **[Required]** Gets the certificate_pem of this UpdateCertificateAuthorityCertificateDetails.
        The externally signed certificate (in PEM format) for the subordinate certificate authority (CA).


        :return: The certificate_pem of this UpdateCertificateAuthorityCertificateDetails.
        :rtype: str
        """
        return self._certificate_pem

    @certificate_pem.setter
    def certificate_pem(self, certificate_pem):
        """
        Sets the certificate_pem of this UpdateCertificateAuthorityCertificateDetails.
        The externally signed certificate (in PEM format) for the subordinate certificate authority (CA).


        :param certificate_pem: The certificate_pem of this UpdateCertificateAuthorityCertificateDetails.
        :type: str
        """
        self._certificate_pem = certificate_pem

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
