# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210224

from .update_certificate_authority_config_details import UpdateCertificateAuthorityConfigDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateRootCaManagedExternallyConfigDetails(UpdateCertificateAuthorityConfigDetails):
    """
    The configuration details for updating an externally managed private root certificate authority (CA) issued by an external CA.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateRootCaManagedExternallyConfigDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.certificates_management.models.UpdateRootCaManagedExternallyConfigDetails.config_type` attribute
        of this class is ``ROOT_CA_MANAGED_EXTERNALLY`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param config_type:
            The value to assign to the config_type property of this UpdateRootCaManagedExternallyConfigDetails.
            Allowed values for this property are: "ROOT_CA_GENERATED_INTERNALLY", "SUBORDINATE_CA_ISSUED_BY_INTERNAL_CA", "ROOT_CA_MANAGED_EXTERNALLY", "SUBORDINATE_CA_MANAGED_INTERNALLY_ISSUED_BY_EXTERNAL_CA"
        :type config_type: str

        :param version_name:
            The value to assign to the version_name property of this UpdateRootCaManagedExternallyConfigDetails.
        :type version_name: str

        :param stage:
            The value to assign to the stage property of this UpdateRootCaManagedExternallyConfigDetails.
            Allowed values for this property are: "CURRENT", "PENDING"
        :type stage: str

        :param certificate_pem:
            The value to assign to the certificate_pem property of this UpdateRootCaManagedExternallyConfigDetails.
        :type certificate_pem: str

        """
        self.swagger_types = {
            'config_type': 'str',
            'version_name': 'str',
            'stage': 'str',
            'certificate_pem': 'str'
        }
        self.attribute_map = {
            'config_type': 'configType',
            'version_name': 'versionName',
            'stage': 'stage',
            'certificate_pem': 'certificatePem'
        }
        self._config_type = None
        self._version_name = None
        self._stage = None
        self._certificate_pem = None
        self._config_type = 'ROOT_CA_MANAGED_EXTERNALLY'

    @property
    def certificate_pem(self):
        """
        **[Required]** Gets the certificate_pem of this UpdateRootCaManagedExternallyConfigDetails.
        The externally signed certificate (in PEM format) for the CA.


        :return: The certificate_pem of this UpdateRootCaManagedExternallyConfigDetails.
        :rtype: str
        """
        return self._certificate_pem

    @certificate_pem.setter
    def certificate_pem(self, certificate_pem):
        """
        Sets the certificate_pem of this UpdateRootCaManagedExternallyConfigDetails.
        The externally signed certificate (in PEM format) for the CA.


        :param certificate_pem: The certificate_pem of this UpdateRootCaManagedExternallyConfigDetails.
        :type: str
        """
        self._certificate_pem = certificate_pem

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
