# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20221208


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CccInfrastructureRoutingDynamicDetails(object):
    """
    Dynamic routing information for the Compute Cloud@Customer infrastructure.
    """

    #: A constant which can be used with the bgp_topology property of a CccInfrastructureRoutingDynamicDetails.
    #: This constant has a value of "TRIANGLE"
    BGP_TOPOLOGY_TRIANGLE = "TRIANGLE"

    #: A constant which can be used with the bgp_topology property of a CccInfrastructureRoutingDynamicDetails.
    #: This constant has a value of "SQUARE"
    BGP_TOPOLOGY_SQUARE = "SQUARE"

    #: A constant which can be used with the bgp_topology property of a CccInfrastructureRoutingDynamicDetails.
    #: This constant has a value of "MESH"
    BGP_TOPOLOGY_MESH = "MESH"

    def __init__(self, **kwargs):
        """
        Initializes a new CccInfrastructureRoutingDynamicDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param peer_information:
            The value to assign to the peer_information property of this CccInfrastructureRoutingDynamicDetails.
        :type peer_information: list[oci.compute_cloud_at_customer.models.PeerInformation]

        :param oracle_asn:
            The value to assign to the oracle_asn property of this CccInfrastructureRoutingDynamicDetails.
        :type oracle_asn: int

        :param bgp_topology:
            The value to assign to the bgp_topology property of this CccInfrastructureRoutingDynamicDetails.
            Allowed values for this property are: "TRIANGLE", "SQUARE", "MESH", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type bgp_topology: str

        """
        self.swagger_types = {
            'peer_information': 'list[PeerInformation]',
            'oracle_asn': 'int',
            'bgp_topology': 'str'
        }
        self.attribute_map = {
            'peer_information': 'peerInformation',
            'oracle_asn': 'oracleAsn',
            'bgp_topology': 'bgpTopology'
        }
        self._peer_information = None
        self._oracle_asn = None
        self._bgp_topology = None

    @property
    def peer_information(self):
        """
        Gets the peer_information of this CccInfrastructureRoutingDynamicDetails.
        The list of peer devices in the dynamic routing configuration.


        :return: The peer_information of this CccInfrastructureRoutingDynamicDetails.
        :rtype: list[oci.compute_cloud_at_customer.models.PeerInformation]
        """
        return self._peer_information

    @peer_information.setter
    def peer_information(self, peer_information):
        """
        Sets the peer_information of this CccInfrastructureRoutingDynamicDetails.
        The list of peer devices in the dynamic routing configuration.


        :param peer_information: The peer_information of this CccInfrastructureRoutingDynamicDetails.
        :type: list[oci.compute_cloud_at_customer.models.PeerInformation]
        """
        self._peer_information = peer_information

    @property
    def oracle_asn(self):
        """
        Gets the oracle_asn of this CccInfrastructureRoutingDynamicDetails.
        The Oracle Autonomous System Number (ASN) to control routing and exchange information
        within the dynamic routing configuration.


        :return: The oracle_asn of this CccInfrastructureRoutingDynamicDetails.
        :rtype: int
        """
        return self._oracle_asn

    @oracle_asn.setter
    def oracle_asn(self, oracle_asn):
        """
        Sets the oracle_asn of this CccInfrastructureRoutingDynamicDetails.
        The Oracle Autonomous System Number (ASN) to control routing and exchange information
        within the dynamic routing configuration.


        :param oracle_asn: The oracle_asn of this CccInfrastructureRoutingDynamicDetails.
        :type: int
        """
        self._oracle_asn = oracle_asn

    @property
    def bgp_topology(self):
        """
        Gets the bgp_topology of this CccInfrastructureRoutingDynamicDetails.
        The topology in use for the Border Gateway Protocol (BGP) configuration.

        Allowed values for this property are: "TRIANGLE", "SQUARE", "MESH", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The bgp_topology of this CccInfrastructureRoutingDynamicDetails.
        :rtype: str
        """
        return self._bgp_topology

    @bgp_topology.setter
    def bgp_topology(self, bgp_topology):
        """
        Sets the bgp_topology of this CccInfrastructureRoutingDynamicDetails.
        The topology in use for the Border Gateway Protocol (BGP) configuration.


        :param bgp_topology: The bgp_topology of this CccInfrastructureRoutingDynamicDetails.
        :type: str
        """
        allowed_values = ["TRIANGLE", "SQUARE", "MESH"]
        if not value_allowed_none_or_none_sentinel(bgp_topology, allowed_values):
            bgp_topology = 'UNKNOWN_ENUM_VALUE'
        self._bgp_topology = bgp_topology

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
