# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20221208


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PeerInformation(object):
    """
    Routing information for peer nodes using the Border Gateway Protocol (BGP).
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PeerInformation object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param asn:
            The value to assign to the asn property of this PeerInformation.
        :type asn: int

        :param ip:
            The value to assign to the ip property of this PeerInformation.
        :type ip: str

        """
        self.swagger_types = {
            'asn': 'int',
            'ip': 'str'
        }
        self.attribute_map = {
            'asn': 'asn',
            'ip': 'ip'
        }
        self._asn = None
        self._ip = None

    @property
    def asn(self):
        """
        Gets the asn of this PeerInformation.
        The Autonomous System Number (ASN) of the peer network.


        :return: The asn of this PeerInformation.
        :rtype: int
        """
        return self._asn

    @asn.setter
    def asn(self, asn):
        """
        Sets the asn of this PeerInformation.
        The Autonomous System Number (ASN) of the peer network.


        :param asn: The asn of this PeerInformation.
        :type: int
        """
        self._asn = asn

    @property
    def ip(self):
        """
        Gets the ip of this PeerInformation.
        Neighbor Border Gateway Protocal (BGP) IP address.
        The IP address usually refers to the customer data center router.


        :return: The ip of this PeerInformation.
        :rtype: str
        """
        return self._ip

    @ip.setter
    def ip(self, ip):
        """
        Sets the ip of this PeerInformation.
        Neighbor Border Gateway Protocal (BGP) IP address.
        The IP address usually refers to the customer data center router.


        :param ip: The ip of this PeerInformation.
        :type: str
        """
        self._ip = ip

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
