# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InstancePoolLifecycleManagementDetails(object):
    """
    The lifecycle management options for the instance pool.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new InstancePoolLifecycleManagementDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param lifecycle_actions:
            The value to assign to the lifecycle_actions property of this InstancePoolLifecycleManagementDetails.
        :type lifecycle_actions: oci.core.models.InstancePoolLifecycleActionsDetails

        """
        self.swagger_types = {
            'lifecycle_actions': 'InstancePoolLifecycleActionsDetails'
        }
        self.attribute_map = {
            'lifecycle_actions': 'lifecycleActions'
        }
        self._lifecycle_actions = None

    @property
    def lifecycle_actions(self):
        """
        **[Required]** Gets the lifecycle_actions of this InstancePoolLifecycleManagementDetails.

        :return: The lifecycle_actions of this InstancePoolLifecycleManagementDetails.
        :rtype: oci.core.models.InstancePoolLifecycleActionsDetails
        """
        return self._lifecycle_actions

    @lifecycle_actions.setter
    def lifecycle_actions(self, lifecycle_actions):
        """
        Sets the lifecycle_actions of this InstancePoolLifecycleManagementDetails.

        :param lifecycle_actions: The lifecycle_actions of this InstancePoolLifecycleManagementDetails.
        :type: oci.core.models.InstancePoolLifecycleActionsDetails
        """
        self._lifecycle_actions = lifecycle_actions

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
