# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200430


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateExportRequestDetails(object):
    """
    Details of export request. Export is supported using three ways.
    First, when objectKeys are provided, export of those objects take place.
    Second, when filter are provided, all the objects based on the filter provided are exported.
    Third, when neither objectKeys nor filters are provided, we export all the design objects for the workspace.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateExportRequestDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param bucket_name:
            The value to assign to the bucket_name property of this CreateExportRequestDetails.
        :type bucket_name: str

        :param file_name:
            The value to assign to the file_name property of this CreateExportRequestDetails.
        :type file_name: str

        :param object_storage_tenancy_id:
            The value to assign to the object_storage_tenancy_id property of this CreateExportRequestDetails.
        :type object_storage_tenancy_id: str

        :param object_storage_region:
            The value to assign to the object_storage_region property of this CreateExportRequestDetails.
        :type object_storage_region: str

        :param is_object_overwrite_enabled:
            The value to assign to the is_object_overwrite_enabled property of this CreateExportRequestDetails.
        :type is_object_overwrite_enabled: bool

        :param object_keys:
            The value to assign to the object_keys property of this CreateExportRequestDetails.
        :type object_keys: list[str]

        :param are_references_included:
            The value to assign to the are_references_included property of this CreateExportRequestDetails.
        :type are_references_included: bool

        :param filters:
            The value to assign to the filters property of this CreateExportRequestDetails.
        :type filters: list[str]

        """
        self.swagger_types = {
            'bucket_name': 'str',
            'file_name': 'str',
            'object_storage_tenancy_id': 'str',
            'object_storage_region': 'str',
            'is_object_overwrite_enabled': 'bool',
            'object_keys': 'list[str]',
            'are_references_included': 'bool',
            'filters': 'list[str]'
        }
        self.attribute_map = {
            'bucket_name': 'bucketName',
            'file_name': 'fileName',
            'object_storage_tenancy_id': 'objectStorageTenancyId',
            'object_storage_region': 'objectStorageRegion',
            'is_object_overwrite_enabled': 'isObjectOverwriteEnabled',
            'object_keys': 'objectKeys',
            'are_references_included': 'areReferencesIncluded',
            'filters': 'filters'
        }
        self._bucket_name = None
        self._file_name = None
        self._object_storage_tenancy_id = None
        self._object_storage_region = None
        self._is_object_overwrite_enabled = None
        self._object_keys = None
        self._are_references_included = None
        self._filters = None

    @property
    def bucket_name(self):
        """
        **[Required]** Gets the bucket_name of this CreateExportRequestDetails.
        Name of the Object Storage bucket where the object will be exported.


        :return: The bucket_name of this CreateExportRequestDetails.
        :rtype: str
        """
        return self._bucket_name

    @bucket_name.setter
    def bucket_name(self, bucket_name):
        """
        Sets the bucket_name of this CreateExportRequestDetails.
        Name of the Object Storage bucket where the object will be exported.


        :param bucket_name: The bucket_name of this CreateExportRequestDetails.
        :type: str
        """
        self._bucket_name = bucket_name

    @property
    def file_name(self):
        """
        Gets the file_name of this CreateExportRequestDetails.
        Name of the exported zip file.


        :return: The file_name of this CreateExportRequestDetails.
        :rtype: str
        """
        return self._file_name

    @file_name.setter
    def file_name(self, file_name):
        """
        Sets the file_name of this CreateExportRequestDetails.
        Name of the exported zip file.


        :param file_name: The file_name of this CreateExportRequestDetails.
        :type: str
        """
        self._file_name = file_name

    @property
    def object_storage_tenancy_id(self):
        """
        Gets the object_storage_tenancy_id of this CreateExportRequestDetails.
        Optional parameter to point to object storage tenancy (if using Object Storage of different tenancy)


        :return: The object_storage_tenancy_id of this CreateExportRequestDetails.
        :rtype: str
        """
        return self._object_storage_tenancy_id

    @object_storage_tenancy_id.setter
    def object_storage_tenancy_id(self, object_storage_tenancy_id):
        """
        Sets the object_storage_tenancy_id of this CreateExportRequestDetails.
        Optional parameter to point to object storage tenancy (if using Object Storage of different tenancy)


        :param object_storage_tenancy_id: The object_storage_tenancy_id of this CreateExportRequestDetails.
        :type: str
        """
        self._object_storage_tenancy_id = object_storage_tenancy_id

    @property
    def object_storage_region(self):
        """
        Gets the object_storage_region of this CreateExportRequestDetails.
        Region of the object storage (if using object storage of different region)


        :return: The object_storage_region of this CreateExportRequestDetails.
        :rtype: str
        """
        return self._object_storage_region

    @object_storage_region.setter
    def object_storage_region(self, object_storage_region):
        """
        Sets the object_storage_region of this CreateExportRequestDetails.
        Region of the object storage (if using object storage of different region)


        :param object_storage_region: The object_storage_region of this CreateExportRequestDetails.
        :type: str
        """
        self._object_storage_region = object_storage_region

    @property
    def is_object_overwrite_enabled(self):
        """
        Gets the is_object_overwrite_enabled of this CreateExportRequestDetails.
        Flag to control whether to overwrite the object if it is already present at the provided object storage location.


        :return: The is_object_overwrite_enabled of this CreateExportRequestDetails.
        :rtype: bool
        """
        return self._is_object_overwrite_enabled

    @is_object_overwrite_enabled.setter
    def is_object_overwrite_enabled(self, is_object_overwrite_enabled):
        """
        Sets the is_object_overwrite_enabled of this CreateExportRequestDetails.
        Flag to control whether to overwrite the object if it is already present at the provided object storage location.


        :param is_object_overwrite_enabled: The is_object_overwrite_enabled of this CreateExportRequestDetails.
        :type: bool
        """
        self._is_object_overwrite_enabled = is_object_overwrite_enabled

    @property
    def object_keys(self):
        """
        Gets the object_keys of this CreateExportRequestDetails.
        Field is used to specify which object keys to export


        :return: The object_keys of this CreateExportRequestDetails.
        :rtype: list[str]
        """
        return self._object_keys

    @object_keys.setter
    def object_keys(self, object_keys):
        """
        Sets the object_keys of this CreateExportRequestDetails.
        Field is used to specify which object keys to export


        :param object_keys: The object_keys of this CreateExportRequestDetails.
        :type: list[str]
        """
        self._object_keys = object_keys

    @property
    def are_references_included(self):
        """
        Gets the are_references_included of this CreateExportRequestDetails.
        This field controls if the references will be exported along with the objects


        :return: The are_references_included of this CreateExportRequestDetails.
        :rtype: bool
        """
        return self._are_references_included

    @are_references_included.setter
    def are_references_included(self, are_references_included):
        """
        Sets the are_references_included of this CreateExportRequestDetails.
        This field controls if the references will be exported along with the objects


        :param are_references_included: The are_references_included of this CreateExportRequestDetails.
        :type: bool
        """
        self._are_references_included = are_references_included

    @property
    def filters(self):
        """
        Gets the filters of this CreateExportRequestDetails.
        Filters for exported objects


        :return: The filters of this CreateExportRequestDetails.
        :rtype: list[str]
        """
        return self._filters

    @filters.setter
    def filters(self, filters):
        """
        Sets the filters of this CreateExportRequestDetails.
        Filters for exported objects


        :param filters: The filters of this CreateExportRequestDetails.
        :type: list[str]
        """
        self._filters = filters

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
