# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Compartments(object):
    """
    Containing the OCID of the compartment and a boolean value to indicates compartmentIdInSubtree.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Compartments object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this Compartments.
        :type id: str

        :param is_include_subtree:
            The value to assign to the is_include_subtree property of this Compartments.
        :type is_include_subtree: bool

        """
        self.swagger_types = {
            'id': 'str',
            'is_include_subtree': 'bool'
        }
        self.attribute_map = {
            'id': 'id',
            'is_include_subtree': 'isIncludeSubtree'
        }
        self._id = None
        self._is_include_subtree = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this Compartments.
        The OCID of the compartment for including target databases to the target database group. All target databases in the compartment will be members of the target database group.


        :return: The id of this Compartments.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Compartments.
        The OCID of the compartment for including target databases to the target database group. All target databases in the compartment will be members of the target database group.


        :param id: The id of this Compartments.
        :type: str
        """
        self._id = id

    @property
    def is_include_subtree(self):
        """
        Gets the is_include_subtree of this Compartments.
        This indicates whether the target databases of sub-compartments should also be included in the target database group. By default, this parameter is set to false.


        :return: The is_include_subtree of this Compartments.
        :rtype: bool
        """
        return self._is_include_subtree

    @is_include_subtree.setter
    def is_include_subtree(self, is_include_subtree):
        """
        Sets the is_include_subtree of this Compartments.
        This indicates whether the target databases of sub-compartments should also be included in the target database group. By default, this parameter is set to false.


        :param is_include_subtree: The is_include_subtree of this Compartments.
        :type: bool
        """
        self._is_include_subtree = is_include_subtree

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
