# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateAuditProfileDetails(object):
    """
    The details used to create a new audit profile.
    """

    #: A constant which can be used with the target_type property of a CreateAuditProfileDetails.
    #: This constant has a value of "TARGET_DATABASE"
    TARGET_TYPE_TARGET_DATABASE = "TARGET_DATABASE"

    #: A constant which can be used with the target_type property of a CreateAuditProfileDetails.
    #: This constant has a value of "TARGET_DATABASE_GROUP"
    TARGET_TYPE_TARGET_DATABASE_GROUP = "TARGET_DATABASE_GROUP"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateAuditProfileDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateAuditProfileDetails.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateAuditProfileDetails.
        :type compartment_id: str

        :param target_id:
            The value to assign to the target_id property of this CreateAuditProfileDetails.
        :type target_id: str

        :param description:
            The value to assign to the description property of this CreateAuditProfileDetails.
        :type description: str

        :param target_type:
            The value to assign to the target_type property of this CreateAuditProfileDetails.
            Allowed values for this property are: "TARGET_DATABASE", "TARGET_DATABASE_GROUP"
        :type target_type: str

        :param is_paid_usage_enabled:
            The value to assign to the is_paid_usage_enabled property of this CreateAuditProfileDetails.
        :type is_paid_usage_enabled: bool

        :param online_months:
            The value to assign to the online_months property of this CreateAuditProfileDetails.
        :type online_months: int

        :param offline_months:
            The value to assign to the offline_months property of this CreateAuditProfileDetails.
        :type offline_months: int

        :param is_override_global_paid_usage:
            The value to assign to the is_override_global_paid_usage property of this CreateAuditProfileDetails.
        :type is_override_global_paid_usage: bool

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateAuditProfileDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateAuditProfileDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'compartment_id': 'str',
            'target_id': 'str',
            'description': 'str',
            'target_type': 'str',
            'is_paid_usage_enabled': 'bool',
            'online_months': 'int',
            'offline_months': 'int',
            'is_override_global_paid_usage': 'bool',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'target_id': 'targetId',
            'description': 'description',
            'target_type': 'targetType',
            'is_paid_usage_enabled': 'isPaidUsageEnabled',
            'online_months': 'onlineMonths',
            'offline_months': 'offlineMonths',
            'is_override_global_paid_usage': 'isOverrideGlobalPaidUsage',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._compartment_id = None
        self._target_id = None
        self._description = None
        self._target_type = None
        self._is_paid_usage_enabled = None
        self._online_months = None
        self._offline_months = None
        self._is_override_global_paid_usage = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateAuditProfileDetails.
        The display name of the audit profile. The name does not have to be unique, and it's updatable.


        :return: The display_name of this CreateAuditProfileDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateAuditProfileDetails.
        The display name of the audit profile. The name does not have to be unique, and it's updatable.


        :param display_name: The display_name of this CreateAuditProfileDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateAuditProfileDetails.
        The OCID of the compartment where you want to create the audit profile.


        :return: The compartment_id of this CreateAuditProfileDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateAuditProfileDetails.
        The OCID of the compartment where you want to create the audit profile.


        :param compartment_id: The compartment_id of this CreateAuditProfileDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def target_id(self):
        """
        **[Required]** Gets the target_id of this CreateAuditProfileDetails.
        The OCID of the target database or target database group for which the audit profile is created.


        :return: The target_id of this CreateAuditProfileDetails.
        :rtype: str
        """
        return self._target_id

    @target_id.setter
    def target_id(self, target_id):
        """
        Sets the target_id of this CreateAuditProfileDetails.
        The OCID of the target database or target database group for which the audit profile is created.


        :param target_id: The target_id of this CreateAuditProfileDetails.
        :type: str
        """
        self._target_id = target_id

    @property
    def description(self):
        """
        Gets the description of this CreateAuditProfileDetails.
        The description of the audit profile.


        :return: The description of this CreateAuditProfileDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateAuditProfileDetails.
        The description of the audit profile.


        :param description: The description of this CreateAuditProfileDetails.
        :type: str
        """
        self._description = description

    @property
    def target_type(self):
        """
        **[Required]** Gets the target_type of this CreateAuditProfileDetails.
        The resource type that is represented by the audit profile.

        Allowed values for this property are: "TARGET_DATABASE", "TARGET_DATABASE_GROUP"


        :return: The target_type of this CreateAuditProfileDetails.
        :rtype: str
        """
        return self._target_type

    @target_type.setter
    def target_type(self, target_type):
        """
        Sets the target_type of this CreateAuditProfileDetails.
        The resource type that is represented by the audit profile.


        :param target_type: The target_type of this CreateAuditProfileDetails.
        :type: str
        """
        allowed_values = ["TARGET_DATABASE", "TARGET_DATABASE_GROUP"]
        if not value_allowed_none_or_none_sentinel(target_type, allowed_values):
            raise ValueError(
                f"Invalid value for `target_type`, must be None or one of {allowed_values}"
            )
        self._target_type = target_type

    @property
    def is_paid_usage_enabled(self):
        """
        Gets the is_paid_usage_enabled of this CreateAuditProfileDetails.
        Indicates if you want to continue collecting audit records beyond the free limit of one million audit records per month per target database,
        potentially incurring additional charges. The default value is inherited from the global settings.
        You can change at the global level or at the target level.


        :return: The is_paid_usage_enabled of this CreateAuditProfileDetails.
        :rtype: bool
        """
        return self._is_paid_usage_enabled

    @is_paid_usage_enabled.setter
    def is_paid_usage_enabled(self, is_paid_usage_enabled):
        """
        Sets the is_paid_usage_enabled of this CreateAuditProfileDetails.
        Indicates if you want to continue collecting audit records beyond the free limit of one million audit records per month per target database,
        potentially incurring additional charges. The default value is inherited from the global settings.
        You can change at the global level or at the target level.


        :param is_paid_usage_enabled: The is_paid_usage_enabled of this CreateAuditProfileDetails.
        :type: bool
        """
        self._is_paid_usage_enabled = is_paid_usage_enabled

    @property
    def online_months(self):
        """
        Gets the online_months of this CreateAuditProfileDetails.
        Number of months the audit records will be stored online in the audit repository for immediate reporting and analysis.
        Minimum: 1; Maximum: 12 months


        :return: The online_months of this CreateAuditProfileDetails.
        :rtype: int
        """
        return self._online_months

    @online_months.setter
    def online_months(self, online_months):
        """
        Sets the online_months of this CreateAuditProfileDetails.
        Number of months the audit records will be stored online in the audit repository for immediate reporting and analysis.
        Minimum: 1; Maximum: 12 months


        :param online_months: The online_months of this CreateAuditProfileDetails.
        :type: int
        """
        self._online_months = online_months

    @property
    def offline_months(self):
        """
        Gets the offline_months of this CreateAuditProfileDetails.
        Number of months the audit records will be stored offline in the offline archive.
        Minimum: 0; Maximum: 72 months.
        If you have a requirement to store the audit data even longer in the offline archive, please contact the Oracle Support.


        :return: The offline_months of this CreateAuditProfileDetails.
        :rtype: int
        """
        return self._offline_months

    @offline_months.setter
    def offline_months(self, offline_months):
        """
        Sets the offline_months of this CreateAuditProfileDetails.
        Number of months the audit records will be stored offline in the offline archive.
        Minimum: 0; Maximum: 72 months.
        If you have a requirement to store the audit data even longer in the offline archive, please contact the Oracle Support.


        :param offline_months: The offline_months of this CreateAuditProfileDetails.
        :type: int
        """
        self._offline_months = offline_months

    @property
    def is_override_global_paid_usage(self):
        """
        Gets the is_override_global_paid_usage of this CreateAuditProfileDetails.
        Indicates whether audit paid usage settings specified at the target database level override both the global and the target database group level paid usage settings.
        Enabling paid usage continues the collection of audit records beyond the free limit of one million audit records per month per target database,
        potentially incurring additional charges. For more information, see `Data Safe Price List`__.

        __ https://www.oracle.com/cloud/price-list/#data-safe


        :return: The is_override_global_paid_usage of this CreateAuditProfileDetails.
        :rtype: bool
        """
        return self._is_override_global_paid_usage

    @is_override_global_paid_usage.setter
    def is_override_global_paid_usage(self, is_override_global_paid_usage):
        """
        Sets the is_override_global_paid_usage of this CreateAuditProfileDetails.
        Indicates whether audit paid usage settings specified at the target database level override both the global and the target database group level paid usage settings.
        Enabling paid usage continues the collection of audit records beyond the free limit of one million audit records per month per target database,
        potentially incurring additional charges. For more information, see `Data Safe Price List`__.

        __ https://www.oracle.com/cloud/price-list/#data-safe


        :param is_override_global_paid_usage: The is_override_global_paid_usage of this CreateAuditProfileDetails.
        :type: bool
        """
        self._is_override_global_paid_usage = is_override_global_paid_usage

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateAuditProfileDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateAuditProfileDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateAuditProfileDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateAuditProfileDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateAuditProfileDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateAuditProfileDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateAuditProfileDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateAuditProfileDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
