# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201

from .selection_details import SelectionDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ListSelectionMode(SelectionDetails):
    """
    Indicates that the selection is a list of resource ocids.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ListSelectionMode object with values from keyword arguments. The default value of the :py:attr:`~oci.data_safe.models.ListSelectionMode.selection_mode` attribute
        of this class is ``LIST`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param selection_mode:
            The value to assign to the selection_mode property of this ListSelectionMode.
            Allowed values for this property are: "LIST", "SCIM_QUERY"
        :type selection_mode: str

        :param items:
            The value to assign to the items property of this ListSelectionMode.
        :type items: list[str]

        """
        self.swagger_types = {
            'selection_mode': 'str',
            'items': 'list[str]'
        }
        self.attribute_map = {
            'selection_mode': 'selectionMode',
            'items': 'items'
        }
        self._selection_mode = None
        self._items = None
        self._selection_mode = 'LIST'

    @property
    def items(self):
        """
        **[Required]** Gets the items of this ListSelectionMode.
        * Array of the violation log ocids to be selected in case of allowed SQLs bulk create.
        * Array of the allowed SQL ocids to be selected in case of allowed SQLs bulk delete.


        :return: The items of this ListSelectionMode.
        :rtype: list[str]
        """
        return self._items

    @items.setter
    def items(self, items):
        """
        Sets the items of this ListSelectionMode.
        * Array of the violation log ocids to be selected in case of allowed SQLs bulk create.
        * Array of the allowed SQL ocids to be selected in case of allowed SQLs bulk delete.


        :param items: The items of this ListSelectionMode.
        :type: list[str]
        """
        self._items = items

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
