# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MatchingCriteria(object):
    """
    Criteria to either include or exclude target databases from the target database group. These criteria can be based on compartments or tags or a list of target databases. See examples below for more details.
    Include: Target databases will be added to the target database group if they match at least one of the include criteria.
    Exclude: Target databases that will be excluded from the target database group (even if they match any of the include criteria).
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MatchingCriteria object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param include:
            The value to assign to the include property of this MatchingCriteria.
        :type include: oci.data_safe.models.Include

        :param exclude:
            The value to assign to the exclude property of this MatchingCriteria.
        :type exclude: oci.data_safe.models.Exclude

        """
        self.swagger_types = {
            'include': 'Include',
            'exclude': 'Exclude'
        }
        self.attribute_map = {
            'include': 'include',
            'exclude': 'exclude'
        }
        self._include = None
        self._exclude = None

    @property
    def include(self):
        """
        **[Required]** Gets the include of this MatchingCriteria.

        :return: The include of this MatchingCriteria.
        :rtype: oci.data_safe.models.Include
        """
        return self._include

    @include.setter
    def include(self, include):
        """
        Sets the include of this MatchingCriteria.

        :param include: The include of this MatchingCriteria.
        :type: oci.data_safe.models.Include
        """
        self._include = include

    @property
    def exclude(self):
        """
        Gets the exclude of this MatchingCriteria.

        :return: The exclude of this MatchingCriteria.
        :rtype: oci.data_safe.models.Exclude
        """
        return self._exclude

    @exclude.setter
    def exclude(self, exclude):
        """
        Sets the exclude of this MatchingCriteria.

        :param exclude: The exclude of this MatchingCriteria.
        :type: oci.data_safe.models.Exclude
        """
        self._exclude = exclude

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
