# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TargetOverrideSummary(object):
    """
    Summary of the target database-specific profiles that override the audit profile of the target database group.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new TargetOverrideSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param target_database_id:
            The value to assign to the target_database_id property of this TargetOverrideSummary.
        :type target_database_id: str

        :param is_paid_usage_enabled:
            The value to assign to the is_paid_usage_enabled property of this TargetOverrideSummary.
        :type is_paid_usage_enabled: bool

        :param online_months:
            The value to assign to the online_months property of this TargetOverrideSummary.
        :type online_months: int

        :param offline_months:
            The value to assign to the offline_months property of this TargetOverrideSummary.
        :type offline_months: int

        :param online_months_source:
            The value to assign to the online_months_source property of this TargetOverrideSummary.
        :type online_months_source: str

        :param offline_months_source:
            The value to assign to the offline_months_source property of this TargetOverrideSummary.
        :type offline_months_source: str

        :param paid_usage_source:
            The value to assign to the paid_usage_source property of this TargetOverrideSummary.
        :type paid_usage_source: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this TargetOverrideSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this TargetOverrideSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this TargetOverrideSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'target_database_id': 'str',
            'is_paid_usage_enabled': 'bool',
            'online_months': 'int',
            'offline_months': 'int',
            'online_months_source': 'str',
            'offline_months_source': 'str',
            'paid_usage_source': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'target_database_id': 'targetDatabaseId',
            'is_paid_usage_enabled': 'isPaidUsageEnabled',
            'online_months': 'onlineMonths',
            'offline_months': 'offlineMonths',
            'online_months_source': 'onlineMonthsSource',
            'offline_months_source': 'offlineMonthsSource',
            'paid_usage_source': 'paidUsageSource',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._target_database_id = None
        self._is_paid_usage_enabled = None
        self._online_months = None
        self._offline_months = None
        self._online_months_source = None
        self._offline_months_source = None
        self._paid_usage_source = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def target_database_id(self):
        """
        **[Required]** Gets the target_database_id of this TargetOverrideSummary.
        The OCID of the target database that overrides from the audit profile of the target database group.


        :return: The target_database_id of this TargetOverrideSummary.
        :rtype: str
        """
        return self._target_database_id

    @target_database_id.setter
    def target_database_id(self, target_database_id):
        """
        Sets the target_database_id of this TargetOverrideSummary.
        The OCID of the target database that overrides from the audit profile of the target database group.


        :param target_database_id: The target_database_id of this TargetOverrideSummary.
        :type: str
        """
        self._target_database_id = target_database_id

    @property
    def is_paid_usage_enabled(self):
        """
        **[Required]** Gets the is_paid_usage_enabled of this TargetOverrideSummary.
        Indicates if you want to continue collecting audit records beyond the free limit of one million audit records per month per target database,
        potentially incurring additional charges. The default value is inherited from the global settings.
        You can change at the global level or at the target level.


        :return: The is_paid_usage_enabled of this TargetOverrideSummary.
        :rtype: bool
        """
        return self._is_paid_usage_enabled

    @is_paid_usage_enabled.setter
    def is_paid_usage_enabled(self, is_paid_usage_enabled):
        """
        Sets the is_paid_usage_enabled of this TargetOverrideSummary.
        Indicates if you want to continue collecting audit records beyond the free limit of one million audit records per month per target database,
        potentially incurring additional charges. The default value is inherited from the global settings.
        You can change at the global level or at the target level.


        :param is_paid_usage_enabled: The is_paid_usage_enabled of this TargetOverrideSummary.
        :type: bool
        """
        self._is_paid_usage_enabled = is_paid_usage_enabled

    @property
    def online_months(self):
        """
        **[Required]** Gets the online_months of this TargetOverrideSummary.
        Number of months the audit records will be stored online in the audit repository for immediate reporting and analysis.
        Minimum: 1; Maximum: 12 months


        :return: The online_months of this TargetOverrideSummary.
        :rtype: int
        """
        return self._online_months

    @online_months.setter
    def online_months(self, online_months):
        """
        Sets the online_months of this TargetOverrideSummary.
        Number of months the audit records will be stored online in the audit repository for immediate reporting and analysis.
        Minimum: 1; Maximum: 12 months


        :param online_months: The online_months of this TargetOverrideSummary.
        :type: int
        """
        self._online_months = online_months

    @property
    def offline_months(self):
        """
        **[Required]** Gets the offline_months of this TargetOverrideSummary.
        Number of months the audit records will be stored offline in the offline archive.
        Minimum: 0; Maximum: 72 months.
        If you have a requirement to store the audit data even longer (up to 168 months) in the offline archive, please contact the Oracle Support.


        :return: The offline_months of this TargetOverrideSummary.
        :rtype: int
        """
        return self._offline_months

    @offline_months.setter
    def offline_months(self, offline_months):
        """
        Sets the offline_months of this TargetOverrideSummary.
        Number of months the audit records will be stored offline in the offline archive.
        Minimum: 0; Maximum: 72 months.
        If you have a requirement to store the audit data even longer (up to 168 months) in the offline archive, please contact the Oracle Support.


        :param offline_months: The offline_months of this TargetOverrideSummary.
        :type: int
        """
        self._offline_months = offline_months

    @property
    def online_months_source(self):
        """
        Gets the online_months_source of this TargetOverrideSummary.
        The name or the OCID of the resource from which the online month retention setting is sourced. For example a target database group OCID or global.


        :return: The online_months_source of this TargetOverrideSummary.
        :rtype: str
        """
        return self._online_months_source

    @online_months_source.setter
    def online_months_source(self, online_months_source):
        """
        Sets the online_months_source of this TargetOverrideSummary.
        The name or the OCID of the resource from which the online month retention setting is sourced. For example a target database group OCID or global.


        :param online_months_source: The online_months_source of this TargetOverrideSummary.
        :type: str
        """
        self._online_months_source = online_months_source

    @property
    def offline_months_source(self):
        """
        Gets the offline_months_source of this TargetOverrideSummary.
        The name or the OCID of the resource from which the offline month retention setting is sourced. For example a target database group OCID or global.


        :return: The offline_months_source of this TargetOverrideSummary.
        :rtype: str
        """
        return self._offline_months_source

    @offline_months_source.setter
    def offline_months_source(self, offline_months_source):
        """
        Sets the offline_months_source of this TargetOverrideSummary.
        The name or the OCID of the resource from which the offline month retention setting is sourced. For example a target database group OCID or global.


        :param offline_months_source: The offline_months_source of this TargetOverrideSummary.
        :type: str
        """
        self._offline_months_source = offline_months_source

    @property
    def paid_usage_source(self):
        """
        Gets the paid_usage_source of this TargetOverrideSummary.
        The name or the OCID of the resource from which the paid usage setting is sourced. For example a target database group OCID or global.


        :return: The paid_usage_source of this TargetOverrideSummary.
        :rtype: str
        """
        return self._paid_usage_source

    @paid_usage_source.setter
    def paid_usage_source(self, paid_usage_source):
        """
        Sets the paid_usage_source of this TargetOverrideSummary.
        The name or the OCID of the resource from which the paid usage setting is sourced. For example a target database group OCID or global.


        :param paid_usage_source: The paid_usage_source of this TargetOverrideSummary.
        :type: str
        """
        self._paid_usage_source = paid_usage_source

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this TargetOverrideSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this TargetOverrideSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this TargetOverrideSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this TargetOverrideSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this TargetOverrideSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this TargetOverrideSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this TargetOverrideSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this TargetOverrideSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this TargetOverrideSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this TargetOverrideSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this TargetOverrideSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this TargetOverrideSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
