# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101

from .create_base_model_group_details import CreateBaseModelGroupDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CloneModelGroupDetails(CreateBaseModelGroupDetails):
    """
    Parameters needed to clone a model group.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CloneModelGroupDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.data_science.models.CloneModelGroupDetails.create_type` attribute
        of this class is ``CLONE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param create_type:
            The value to assign to the create_type property of this CloneModelGroupDetails.
            Allowed values for this property are: "CREATE", "CLONE"
        :type create_type: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CloneModelGroupDetails.
        :type compartment_id: str

        :param project_id:
            The value to assign to the project_id property of this CloneModelGroupDetails.
        :type project_id: str

        :param model_group_clone_source_details:
            The value to assign to the model_group_clone_source_details property of this CloneModelGroupDetails.
        :type model_group_clone_source_details: oci.data_science.models.ModelGroupCloneSourceDetails

        """
        self.swagger_types = {
            'create_type': 'str',
            'compartment_id': 'str',
            'project_id': 'str',
            'model_group_clone_source_details': 'ModelGroupCloneSourceDetails'
        }
        self.attribute_map = {
            'create_type': 'createType',
            'compartment_id': 'compartmentId',
            'project_id': 'projectId',
            'model_group_clone_source_details': 'modelGroupCloneSourceDetails'
        }
        self._create_type = None
        self._compartment_id = None
        self._project_id = None
        self._model_group_clone_source_details = None
        self._create_type = 'CLONE'

    @property
    def model_group_clone_source_details(self):
        """
        **[Required]** Gets the model_group_clone_source_details of this CloneModelGroupDetails.

        :return: The model_group_clone_source_details of this CloneModelGroupDetails.
        :rtype: oci.data_science.models.ModelGroupCloneSourceDetails
        """
        return self._model_group_clone_source_details

    @model_group_clone_source_details.setter
    def model_group_clone_source_details(self, model_group_clone_source_details):
        """
        Sets the model_group_clone_source_details of this CloneModelGroupDetails.

        :param model_group_clone_source_details: The model_group_clone_source_details of this CloneModelGroupDetails.
        :type: oci.data_science.models.ModelGroupCloneSourceDetails
        """
        self._model_group_clone_source_details = model_group_clone_source_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
