# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ContainerSummary(object):
    """
    Summary representation of a container
    """

    #: A constant which can be used with the target_workloads property of a ContainerSummary.
    #: This constant has a value of "MODEL_DEPLOYMENT"
    TARGET_WORKLOADS_MODEL_DEPLOYMENT = "MODEL_DEPLOYMENT"

    #: A constant which can be used with the target_workloads property of a ContainerSummary.
    #: This constant has a value of "JOB_RUN"
    TARGET_WORKLOADS_JOB_RUN = "JOB_RUN"

    #: A constant which can be used with the usages property of a ContainerSummary.
    #: This constant has a value of "INFERENCE"
    USAGES_INFERENCE = "INFERENCE"

    #: A constant which can be used with the usages property of a ContainerSummary.
    #: This constant has a value of "FINE_TUNE"
    USAGES_FINE_TUNE = "FINE_TUNE"

    #: A constant which can be used with the usages property of a ContainerSummary.
    #: This constant has a value of "EVALUATION"
    USAGES_EVALUATION = "EVALUATION"

    #: A constant which can be used with the usages property of a ContainerSummary.
    #: This constant has a value of "BATCH_INFERENCE"
    USAGES_BATCH_INFERENCE = "BATCH_INFERENCE"

    #: A constant which can be used with the usages property of a ContainerSummary.
    #: This constant has a value of "OTHER"
    USAGES_OTHER = "OTHER"

    #: A constant which can be used with the lifecycle_state property of a ContainerSummary.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a ContainerSummary.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    def __init__(self, **kwargs):
        """
        Initializes a new ContainerSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param container_name:
            The value to assign to the container_name property of this ContainerSummary.
        :type container_name: str

        :param display_name:
            The value to assign to the display_name property of this ContainerSummary.
        :type display_name: str

        :param family_name:
            The value to assign to the family_name property of this ContainerSummary.
        :type family_name: str

        :param description:
            The value to assign to the description property of this ContainerSummary.
        :type description: str

        :param is_latest:
            The value to assign to the is_latest property of this ContainerSummary.
        :type is_latest: bool

        :param target_workloads:
            The value to assign to the target_workloads property of this ContainerSummary.
            Allowed values for items in this list are: "MODEL_DEPLOYMENT", "JOB_RUN", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type target_workloads: list[str]

        :param usages:
            The value to assign to the usages property of this ContainerSummary.
            Allowed values for items in this list are: "INFERENCE", "FINE_TUNE", "EVALUATION", "BATCH_INFERENCE", "OTHER", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type usages: list[str]

        :param tag:
            The value to assign to the tag property of this ContainerSummary.
        :type tag: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ContainerSummary.
            Allowed values for this property are: "ACTIVE", "INACTIVE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param workload_configuration_details_list:
            The value to assign to the workload_configuration_details_list property of this ContainerSummary.
        :type workload_configuration_details_list: list[oci.data_science.models.WorkloadConfigurationDetails]

        :param tag_configuration_list:
            The value to assign to the tag_configuration_list property of this ContainerSummary.
        :type tag_configuration_list: list[oci.data_science.models.TagConfiguration]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ContainerSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this ContainerSummary.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'container_name': 'str',
            'display_name': 'str',
            'family_name': 'str',
            'description': 'str',
            'is_latest': 'bool',
            'target_workloads': 'list[str]',
            'usages': 'list[str]',
            'tag': 'str',
            'lifecycle_state': 'str',
            'workload_configuration_details_list': 'list[WorkloadConfigurationDetails]',
            'tag_configuration_list': 'list[TagConfiguration]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'container_name': 'containerName',
            'display_name': 'displayName',
            'family_name': 'familyName',
            'description': 'description',
            'is_latest': 'isLatest',
            'target_workloads': 'targetWorkloads',
            'usages': 'usages',
            'tag': 'tag',
            'lifecycle_state': 'lifecycleState',
            'workload_configuration_details_list': 'workloadConfigurationDetailsList',
            'tag_configuration_list': 'tagConfigurationList',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._container_name = None
        self._display_name = None
        self._family_name = None
        self._description = None
        self._is_latest = None
        self._target_workloads = None
        self._usages = None
        self._tag = None
        self._lifecycle_state = None
        self._workload_configuration_details_list = None
        self._tag_configuration_list = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def container_name(self):
        """
        **[Required]** Gets the container_name of this ContainerSummary.
        The name of the container. This can be same for different tags


        :return: The container_name of this ContainerSummary.
        :rtype: str
        """
        return self._container_name

    @container_name.setter
    def container_name(self, container_name):
        """
        Sets the container_name of this ContainerSummary.
        The name of the container. This can be same for different tags


        :param container_name: The container_name of this ContainerSummary.
        :type: str
        """
        self._container_name = container_name

    @property
    def display_name(self):
        """
        Gets the display_name of this ContainerSummary.
        The display name of the container.


        :return: The display_name of this ContainerSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ContainerSummary.
        The display name of the container.


        :param display_name: The display_name of this ContainerSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def family_name(self):
        """
        Gets the family_name of this ContainerSummary.
        The family name of the container.


        :return: The family_name of this ContainerSummary.
        :rtype: str
        """
        return self._family_name

    @family_name.setter
    def family_name(self, family_name):
        """
        Sets the family_name of this ContainerSummary.
        The family name of the container.


        :param family_name: The family_name of this ContainerSummary.
        :type: str
        """
        self._family_name = family_name

    @property
    def description(self):
        """
        Gets the description of this ContainerSummary.
        Description of the container.


        :return: The description of this ContainerSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ContainerSummary.
        Description of the container.


        :param description: The description of this ContainerSummary.
        :type: str
        """
        self._description = description

    @property
    def is_latest(self):
        """
        **[Required]** Gets the is_latest of this ContainerSummary.
        The latest tag of the container.


        :return: The is_latest of this ContainerSummary.
        :rtype: bool
        """
        return self._is_latest

    @is_latest.setter
    def is_latest(self, is_latest):
        """
        Sets the is_latest of this ContainerSummary.
        The latest tag of the container.


        :param is_latest: The is_latest of this ContainerSummary.
        :type: bool
        """
        self._is_latest = is_latest

    @property
    def target_workloads(self):
        """
        Gets the target_workloads of this ContainerSummary.
        The list of target workload. This Container can be used with given data science resources.

        Allowed values for items in this list are: "MODEL_DEPLOYMENT", "JOB_RUN", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The target_workloads of this ContainerSummary.
        :rtype: list[str]
        """
        return self._target_workloads

    @target_workloads.setter
    def target_workloads(self, target_workloads):
        """
        Sets the target_workloads of this ContainerSummary.
        The list of target workload. This Container can be used with given data science resources.


        :param target_workloads: The target_workloads of this ContainerSummary.
        :type: list[str]
        """
        allowed_values = ["MODEL_DEPLOYMENT", "JOB_RUN"]
        if target_workloads:
            target_workloads[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in target_workloads]
        self._target_workloads = target_workloads

    @property
    def usages(self):
        """
        Gets the usages of this ContainerSummary.
        The list of usages of this container. This Container can be used for given use-cases.

        Allowed values for items in this list are: "INFERENCE", "FINE_TUNE", "EVALUATION", "BATCH_INFERENCE", "OTHER", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The usages of this ContainerSummary.
        :rtype: list[str]
        """
        return self._usages

    @usages.setter
    def usages(self, usages):
        """
        Sets the usages of this ContainerSummary.
        The list of usages of this container. This Container can be used for given use-cases.


        :param usages: The usages of this ContainerSummary.
        :type: list[str]
        """
        allowed_values = ["INFERENCE", "FINE_TUNE", "EVALUATION", "BATCH_INFERENCE", "OTHER"]
        if usages:
            usages[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in usages]
        self._usages = usages

    @property
    def tag(self):
        """
        **[Required]** Gets the tag of this ContainerSummary.
        Container Tag.


        :return: The tag of this ContainerSummary.
        :rtype: str
        """
        return self._tag

    @tag.setter
    def tag(self, tag):
        """
        Sets the tag of this ContainerSummary.
        Container Tag.


        :param tag: The tag of this ContainerSummary.
        :type: str
        """
        self._tag = tag

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this ContainerSummary.
        Container Version LifecycleState.

        Allowed values for this property are: "ACTIVE", "INACTIVE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this ContainerSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ContainerSummary.
        Container Version LifecycleState.


        :param lifecycle_state: The lifecycle_state of this ContainerSummary.
        :type: str
        """
        allowed_values = ["ACTIVE", "INACTIVE"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def workload_configuration_details_list(self):
        """
        Gets the workload_configuration_details_list of this ContainerSummary.
        workload configuration of the container.


        :return: The workload_configuration_details_list of this ContainerSummary.
        :rtype: list[oci.data_science.models.WorkloadConfigurationDetails]
        """
        return self._workload_configuration_details_list

    @workload_configuration_details_list.setter
    def workload_configuration_details_list(self, workload_configuration_details_list):
        """
        Sets the workload_configuration_details_list of this ContainerSummary.
        workload configuration of the container.


        :param workload_configuration_details_list: The workload_configuration_details_list of this ContainerSummary.
        :type: list[oci.data_science.models.WorkloadConfigurationDetails]
        """
        self._workload_configuration_details_list = workload_configuration_details_list

    @property
    def tag_configuration_list(self):
        """
        Gets the tag_configuration_list of this ContainerSummary.
        An array of defined metadata details for the model.


        :return: The tag_configuration_list of this ContainerSummary.
        :rtype: list[oci.data_science.models.TagConfiguration]
        """
        return self._tag_configuration_list

    @tag_configuration_list.setter
    def tag_configuration_list(self, tag_configuration_list):
        """
        Sets the tag_configuration_list of this ContainerSummary.
        An array of defined metadata details for the model.


        :param tag_configuration_list: The tag_configuration_list of this ContainerSummary.
        :type: list[oci.data_science.models.TagConfiguration]
        """
        self._tag_configuration_list = tag_configuration_list

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this ContainerSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this ContainerSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ContainerSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this ContainerSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this ContainerSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this ContainerSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ContainerSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this ContainerSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
