# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InstanceComponent(object):
    """
    Reference to instance component
    """

    #: A constant which can be used with the type property of a InstanceComponent.
    #: This constant has a value of "DATA_SCIENCE_MODEL_DEPLOYMENT"
    TYPE_DATA_SCIENCE_MODEL_DEPLOYMENT = "DATA_SCIENCE_MODEL_DEPLOYMENT"

    #: A constant which can be used with the type property of a InstanceComponent.
    #: This constant has a value of "OBJECT_STORAGE_BUCKET"
    TYPE_OBJECT_STORAGE_BUCKET = "OBJECT_STORAGE_BUCKET"

    #: A constant which can be used with the type property of a InstanceComponent.
    #: This constant has a value of "OBJECT_STORAGE_OBJECT"
    TYPE_OBJECT_STORAGE_OBJECT = "OBJECT_STORAGE_OBJECT"

    #: A constant which can be used with the type property of a InstanceComponent.
    #: This constant has a value of "ML_APPLICATION_INSTANCE_INTERNAL_TRIGGER"
    TYPE_ML_APPLICATION_INSTANCE_INTERNAL_TRIGGER = "ML_APPLICATION_INSTANCE_INTERNAL_TRIGGER"

    #: A constant which can be used with the type property of a InstanceComponent.
    #: This constant has a value of "DATA_SCIENCE_SCHEDULE"
    TYPE_DATA_SCIENCE_SCHEDULE = "DATA_SCIENCE_SCHEDULE"

    #: A constant which can be used with the type property of a InstanceComponent.
    #: This constant has a value of "GENERIC_OCI_RESOURCE"
    TYPE_GENERIC_OCI_RESOURCE = "GENERIC_OCI_RESOURCE"

    def __init__(self, **kwargs):
        """
        Initializes a new InstanceComponent object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.data_science.models.DataScienceModelDeploymentInstanceComponent`
        * :class:`~oci.data_science.models.GenericOciResourceInstanceComponent`
        * :class:`~oci.data_science.models.MlApplicationInstanceInternalTrigger`
        * :class:`~oci.data_science.models.DataScienceScheduleInstanceComponent`
        * :class:`~oci.data_science.models.ObjectStorageObjectInstanceComponent`
        * :class:`~oci.data_science.models.ObjectStorageBucketInstanceComponent`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this InstanceComponent.
            Allowed values for this property are: "DATA_SCIENCE_MODEL_DEPLOYMENT", "OBJECT_STORAGE_BUCKET", "OBJECT_STORAGE_OBJECT", "ML_APPLICATION_INSTANCE_INTERNAL_TRIGGER", "DATA_SCIENCE_SCHEDULE", "GENERIC_OCI_RESOURCE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param name:
            The value to assign to the name property of this InstanceComponent.
        :type name: str

        :param component_name:
            The value to assign to the component_name property of this InstanceComponent.
        :type component_name: str

        """
        self.swagger_types = {
            'type': 'str',
            'name': 'str',
            'component_name': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'name': 'name',
            'component_name': 'componentName'
        }
        self._type = None
        self._name = None
        self._component_name = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['type']

        if type == 'DATA_SCIENCE_MODEL_DEPLOYMENT':
            return 'DataScienceModelDeploymentInstanceComponent'

        if type == 'GENERIC_OCI_RESOURCE':
            return 'GenericOciResourceInstanceComponent'

        if type == 'ML_APPLICATION_INSTANCE_INTERNAL_TRIGGER':
            return 'MlApplicationInstanceInternalTrigger'

        if type == 'DATA_SCIENCE_SCHEDULE':
            return 'DataScienceScheduleInstanceComponent'

        if type == 'OBJECT_STORAGE_OBJECT':
            return 'ObjectStorageObjectInstanceComponent'

        if type == 'OBJECT_STORAGE_BUCKET':
            return 'ObjectStorageBucketInstanceComponent'
        else:
            return 'InstanceComponent'

    @property
    def type(self):
        """
        **[Required]** Gets the type of this InstanceComponent.
        Type of instance component

        Allowed values for this property are: "DATA_SCIENCE_MODEL_DEPLOYMENT", "OBJECT_STORAGE_BUCKET", "OBJECT_STORAGE_OBJECT", "ML_APPLICATION_INSTANCE_INTERNAL_TRIGGER", "DATA_SCIENCE_SCHEDULE", "GENERIC_OCI_RESOURCE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this InstanceComponent.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this InstanceComponent.
        Type of instance component


        :param type: The type of this InstanceComponent.
        :type: str
        """
        allowed_values = ["DATA_SCIENCE_MODEL_DEPLOYMENT", "OBJECT_STORAGE_BUCKET", "OBJECT_STORAGE_OBJECT", "ML_APPLICATION_INSTANCE_INTERNAL_TRIGGER", "DATA_SCIENCE_SCHEDULE", "GENERIC_OCI_RESOURCE"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def name(self):
        """
        Gets the name of this InstanceComponent.
        Name of referenced resource (generally resources do not have to have any name but most resources have name exposed as 'name' or 'displayName' field).


        :return: The name of this InstanceComponent.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this InstanceComponent.
        Name of referenced resource (generally resources do not have to have any name but most resources have name exposed as 'name' or 'displayName' field).


        :param name: The name of this InstanceComponent.
        :type: str
        """
        self._name = name

    @property
    def component_name(self):
        """
        **[Required]** Gets the component_name of this InstanceComponent.
        Name of instance component


        :return: The component_name of this InstanceComponent.
        :rtype: str
        """
        return self._component_name

    @component_name.setter
    def component_name(self, component_name):
        """
        Sets the component_name of this InstanceComponent.
        Name of instance component


        :param component_name: The component_name of this InstanceComponent.
        :type: str
        """
        self._component_name = component_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
