# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MemberModelDetails(object):
    """
    Model details which needs to be part of Model Group.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MemberModelDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param inference_key:
            The value to assign to the inference_key property of this MemberModelDetails.
        :type inference_key: str

        :param model_id:
            The value to assign to the model_id property of this MemberModelDetails.
        :type model_id: str

        """
        self.swagger_types = {
            'inference_key': 'str',
            'model_id': 'str'
        }
        self.attribute_map = {
            'inference_key': 'inferenceKey',
            'model_id': 'modelId'
        }
        self._inference_key = None
        self._model_id = None

    @property
    def inference_key(self):
        """
        Gets the inference_key of this MemberModelDetails.
        SaaS friendly name of the model.


        :return: The inference_key of this MemberModelDetails.
        :rtype: str
        """
        return self._inference_key

    @inference_key.setter
    def inference_key(self, inference_key):
        """
        Sets the inference_key of this MemberModelDetails.
        SaaS friendly name of the model.


        :param inference_key: The inference_key of this MemberModelDetails.
        :type: str
        """
        self._inference_key = inference_key

    @property
    def model_id(self):
        """
        **[Required]** Gets the model_id of this MemberModelDetails.
        The `OCID`__ of the model.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The model_id of this MemberModelDetails.
        :rtype: str
        """
        return self._model_id

    @model_id.setter
    def model_id(self, model_id):
        """
        Sets the model_id of this MemberModelDetails.
        The `OCID`__ of the model.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param model_id: The model_id of this MemberModelDetails.
        :type: str
        """
        self._model_id = model_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
