# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MlApplicationInstanceSummary(object):
    """
    Summary of the MlApplicationInstance.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MlApplicationInstanceSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this MlApplicationInstanceSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this MlApplicationInstanceSummary.
        :type display_name: str

        :param ml_application_id:
            The value to assign to the ml_application_id property of this MlApplicationInstanceSummary.
        :type ml_application_id: str

        :param ml_application_name:
            The value to assign to the ml_application_name property of this MlApplicationInstanceSummary.
        :type ml_application_name: str

        :param ml_application_implementation_id:
            The value to assign to the ml_application_implementation_id property of this MlApplicationInstanceSummary.
        :type ml_application_implementation_id: str

        :param ml_application_implementation_name:
            The value to assign to the ml_application_implementation_name property of this MlApplicationInstanceSummary.
        :type ml_application_implementation_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this MlApplicationInstanceSummary.
        :type compartment_id: str

        :param time_created:
            The value to assign to the time_created property of this MlApplicationInstanceSummary.
        :type time_created: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this MlApplicationInstanceSummary.
        :type lifecycle_state: str

        :param lifecycle_substate:
            The value to assign to the lifecycle_substate property of this MlApplicationInstanceSummary.
        :type lifecycle_substate: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this MlApplicationInstanceSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this MlApplicationInstanceSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this MlApplicationInstanceSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'ml_application_id': 'str',
            'ml_application_name': 'str',
            'ml_application_implementation_id': 'str',
            'ml_application_implementation_name': 'str',
            'compartment_id': 'str',
            'time_created': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_substate': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'ml_application_id': 'mlApplicationId',
            'ml_application_name': 'mlApplicationName',
            'ml_application_implementation_id': 'mlApplicationImplementationId',
            'ml_application_implementation_name': 'mlApplicationImplementationName',
            'compartment_id': 'compartmentId',
            'time_created': 'timeCreated',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_substate': 'lifecycleSubstate',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._ml_application_id = None
        self._ml_application_name = None
        self._ml_application_implementation_id = None
        self._ml_application_implementation_name = None
        self._compartment_id = None
        self._time_created = None
        self._lifecycle_state = None
        self._lifecycle_substate = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this MlApplicationInstanceSummary.
        The OCID of the MlApplicationInstance. Unique identifier that is immutable after creation


        :return: The id of this MlApplicationInstanceSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this MlApplicationInstanceSummary.
        The OCID of the MlApplicationInstance. Unique identifier that is immutable after creation


        :param id: The id of this MlApplicationInstanceSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this MlApplicationInstanceSummary.
        The name of MlApplicationInstance. System will generate displayName when not provided during creation.


        :return: The display_name of this MlApplicationInstanceSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this MlApplicationInstanceSummary.
        The name of MlApplicationInstance. System will generate displayName when not provided during creation.


        :param display_name: The display_name of this MlApplicationInstanceSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def ml_application_id(self):
        """
        **[Required]** Gets the ml_application_id of this MlApplicationInstanceSummary.
        The OCID of ML Application. This resource is an instance of ML Application referenced by this OCID.


        :return: The ml_application_id of this MlApplicationInstanceSummary.
        :rtype: str
        """
        return self._ml_application_id

    @ml_application_id.setter
    def ml_application_id(self, ml_application_id):
        """
        Sets the ml_application_id of this MlApplicationInstanceSummary.
        The OCID of ML Application. This resource is an instance of ML Application referenced by this OCID.


        :param ml_application_id: The ml_application_id of this MlApplicationInstanceSummary.
        :type: str
        """
        self._ml_application_id = ml_application_id

    @property
    def ml_application_name(self):
        """
        **[Required]** Gets the ml_application_name of this MlApplicationInstanceSummary.
        The name of ML Application (based on mlApplicationId).


        :return: The ml_application_name of this MlApplicationInstanceSummary.
        :rtype: str
        """
        return self._ml_application_name

    @ml_application_name.setter
    def ml_application_name(self, ml_application_name):
        """
        Sets the ml_application_name of this MlApplicationInstanceSummary.
        The name of ML Application (based on mlApplicationId).


        :param ml_application_name: The ml_application_name of this MlApplicationInstanceSummary.
        :type: str
        """
        self._ml_application_name = ml_application_name

    @property
    def ml_application_implementation_id(self):
        """
        **[Required]** Gets the ml_application_implementation_id of this MlApplicationInstanceSummary.
        The OCID of ML Application Implementation selected as a certain solution for a given ML problem (ML Application)


        :return: The ml_application_implementation_id of this MlApplicationInstanceSummary.
        :rtype: str
        """
        return self._ml_application_implementation_id

    @ml_application_implementation_id.setter
    def ml_application_implementation_id(self, ml_application_implementation_id):
        """
        Sets the ml_application_implementation_id of this MlApplicationInstanceSummary.
        The OCID of ML Application Implementation selected as a certain solution for a given ML problem (ML Application)


        :param ml_application_implementation_id: The ml_application_implementation_id of this MlApplicationInstanceSummary.
        :type: str
        """
        self._ml_application_implementation_id = ml_application_implementation_id

    @property
    def ml_application_implementation_name(self):
        """
        **[Required]** Gets the ml_application_implementation_name of this MlApplicationInstanceSummary.
        The name of Ml Application Implementation (based on mlApplicationImplementationId)


        :return: The ml_application_implementation_name of this MlApplicationInstanceSummary.
        :rtype: str
        """
        return self._ml_application_implementation_name

    @ml_application_implementation_name.setter
    def ml_application_implementation_name(self, ml_application_implementation_name):
        """
        Sets the ml_application_implementation_name of this MlApplicationInstanceSummary.
        The name of Ml Application Implementation (based on mlApplicationImplementationId)


        :param ml_application_implementation_name: The ml_application_implementation_name of this MlApplicationInstanceSummary.
        :type: str
        """
        self._ml_application_implementation_name = ml_application_implementation_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this MlApplicationInstanceSummary.
        The OCID of the compartment where you the MlApplicationInstance is created.


        :return: The compartment_id of this MlApplicationInstanceSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this MlApplicationInstanceSummary.
        The OCID of the compartment where you the MlApplicationInstance is created.


        :param compartment_id: The compartment_id of this MlApplicationInstanceSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this MlApplicationInstanceSummary.
        The time the the MlApplication was created. An RFC3339 formatted datetime string


        :return: The time_created of this MlApplicationInstanceSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this MlApplicationInstanceSummary.
        The time the the MlApplication was created. An RFC3339 formatted datetime string


        :param time_created: The time_created of this MlApplicationInstanceSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this MlApplicationInstanceSummary.
        The current state of the MlApplicationInstance.


        :return: The lifecycle_state of this MlApplicationInstanceSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this MlApplicationInstanceSummary.
        The current state of the MlApplicationInstance.


        :param lifecycle_state: The lifecycle_state of this MlApplicationInstanceSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_substate(self):
        """
        **[Required]** Gets the lifecycle_substate of this MlApplicationInstanceSummary.
        The current substate of the MlApplicationInstance. The substate has MlApplicationInstance specific values in comparison with lifecycleState which has standard values common for all OCI resources.


        :return: The lifecycle_substate of this MlApplicationInstanceSummary.
        :rtype: str
        """
        return self._lifecycle_substate

    @lifecycle_substate.setter
    def lifecycle_substate(self, lifecycle_substate):
        """
        Sets the lifecycle_substate of this MlApplicationInstanceSummary.
        The current substate of the MlApplicationInstance. The substate has MlApplicationInstance specific values in comparison with lifecycleState which has standard values common for all OCI resources.


        :param lifecycle_substate: The lifecycle_substate of this MlApplicationInstanceSummary.
        :type: str
        """
        self._lifecycle_substate = lifecycle_substate

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this MlApplicationInstanceSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this MlApplicationInstanceSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this MlApplicationInstanceSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this MlApplicationInstanceSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this MlApplicationInstanceSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this MlApplicationInstanceSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this MlApplicationInstanceSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this MlApplicationInstanceSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this MlApplicationInstanceSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this MlApplicationInstanceSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this MlApplicationInstanceSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this MlApplicationInstanceSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
