# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101

from .pipeline_step_update_details import PipelineStepUpdateDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PipelineMLJobStepUpdateDetails(PipelineStepUpdateDetails):
    """
    The type of step where the job is pre-created by the user.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PipelineMLJobStepUpdateDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.data_science.models.PipelineMLJobStepUpdateDetails.step_type` attribute
        of this class is ``ML_JOB`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param step_type:
            The value to assign to the step_type property of this PipelineMLJobStepUpdateDetails.
            Allowed values for this property are: "ML_JOB", "CUSTOM_SCRIPT", "CONTAINER", "DATAFLOW"
        :type step_type: str

        :param step_name:
            The value to assign to the step_name property of this PipelineMLJobStepUpdateDetails.
        :type step_name: str

        :param description:
            The value to assign to the description property of this PipelineMLJobStepUpdateDetails.
        :type description: str

        :param step_configuration_details:
            The value to assign to the step_configuration_details property of this PipelineMLJobStepUpdateDetails.
        :type step_configuration_details: oci.data_science.models.PipelineStepConfigurationDetails

        :param step_run_name:
            The value to assign to the step_run_name property of this PipelineMLJobStepUpdateDetails.
        :type step_run_name: str

        :param step_parameters:
            The value to assign to the step_parameters property of this PipelineMLJobStepUpdateDetails.
        :type step_parameters: oci.data_science.models.PipelineStepParameterDetails

        """
        self.swagger_types = {
            'step_type': 'str',
            'step_name': 'str',
            'description': 'str',
            'step_configuration_details': 'PipelineStepConfigurationDetails',
            'step_run_name': 'str',
            'step_parameters': 'PipelineStepParameterDetails'
        }
        self.attribute_map = {
            'step_type': 'stepType',
            'step_name': 'stepName',
            'description': 'description',
            'step_configuration_details': 'stepConfigurationDetails',
            'step_run_name': 'stepRunName',
            'step_parameters': 'stepParameters'
        }
        self._step_type = None
        self._step_name = None
        self._description = None
        self._step_configuration_details = None
        self._step_run_name = None
        self._step_parameters = None
        self._step_type = 'ML_JOB'

    @property
    def step_run_name(self):
        """
        Gets the step_run_name of this PipelineMLJobStepUpdateDetails.
        Name used when creating the steprun.


        :return: The step_run_name of this PipelineMLJobStepUpdateDetails.
        :rtype: str
        """
        return self._step_run_name

    @step_run_name.setter
    def step_run_name(self, step_run_name):
        """
        Sets the step_run_name of this PipelineMLJobStepUpdateDetails.
        Name used when creating the steprun.


        :param step_run_name: The step_run_name of this PipelineMLJobStepUpdateDetails.
        :type: str
        """
        self._step_run_name = step_run_name

    @property
    def step_parameters(self):
        """
        Gets the step_parameters of this PipelineMLJobStepUpdateDetails.

        :return: The step_parameters of this PipelineMLJobStepUpdateDetails.
        :rtype: oci.data_science.models.PipelineStepParameterDetails
        """
        return self._step_parameters

    @step_parameters.setter
    def step_parameters(self, step_parameters):
        """
        Sets the step_parameters of this PipelineMLJobStepUpdateDetails.

        :param step_parameters: The step_parameters of this PipelineMLJobStepUpdateDetails.
        :type: oci.data_science.models.PipelineStepParameterDetails
        """
        self._step_parameters = step_parameters

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
