# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class EstimateCostSavingSummary(object):
    """
    Autonomous AI Database cost savings.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new EstimateCostSavingSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param time_started:
            The value to assign to the time_started property of this EstimateCostSavingSummary.
        :type time_started: datetime

        :param time_ended:
            The value to assign to the time_ended property of this EstimateCostSavingSummary.
        :type time_ended: datetime

        :param is_cpu_autoscale:
            The value to assign to the is_cpu_autoscale property of this EstimateCostSavingSummary.
        :type is_cpu_autoscale: bool

        :param estimated_usage_without_elastic_pool:
            The value to assign to the estimated_usage_without_elastic_pool property of this EstimateCostSavingSummary.
        :type estimated_usage_without_elastic_pool: int

        :param usage_with_elastic_pool:
            The value to assign to the usage_with_elastic_pool property of this EstimateCostSavingSummary.
        :type usage_with_elastic_pool: int

        :param cost_savings_with_elastic_pool:
            The value to assign to the cost_savings_with_elastic_pool property of this EstimateCostSavingSummary.
        :type cost_savings_with_elastic_pool: float

        """
        self.swagger_types = {
            'time_started': 'datetime',
            'time_ended': 'datetime',
            'is_cpu_autoscale': 'bool',
            'estimated_usage_without_elastic_pool': 'int',
            'usage_with_elastic_pool': 'int',
            'cost_savings_with_elastic_pool': 'float'
        }
        self.attribute_map = {
            'time_started': 'timeStarted',
            'time_ended': 'timeEnded',
            'is_cpu_autoscale': 'isCpuAutoscale',
            'estimated_usage_without_elastic_pool': 'estimatedUsageWithoutElasticPool',
            'usage_with_elastic_pool': 'usageWithElasticPool',
            'cost_savings_with_elastic_pool': 'costSavingsWithElasticPool'
        }
        self._time_started = None
        self._time_ended = None
        self._is_cpu_autoscale = None
        self._estimated_usage_without_elastic_pool = None
        self._usage_with_elastic_pool = None
        self._cost_savings_with_elastic_pool = None

    @property
    def time_started(self):
        """
        Gets the time_started of this EstimateCostSavingSummary.
        The epoch time at which cost aggregation starts.


        :return: The time_started of this EstimateCostSavingSummary.
        :rtype: datetime
        """
        return self._time_started

    @time_started.setter
    def time_started(self, time_started):
        """
        Sets the time_started of this EstimateCostSavingSummary.
        The epoch time at which cost aggregation starts.


        :param time_started: The time_started of this EstimateCostSavingSummary.
        :type: datetime
        """
        self._time_started = time_started

    @property
    def time_ended(self):
        """
        Gets the time_ended of this EstimateCostSavingSummary.
        The epoch time at which cost aggregation ends.


        :return: The time_ended of this EstimateCostSavingSummary.
        :rtype: datetime
        """
        return self._time_ended

    @time_ended.setter
    def time_ended(self, time_ended):
        """
        Sets the time_ended of this EstimateCostSavingSummary.
        The epoch time at which cost aggregation ends.


        :param time_ended: The time_ended of this EstimateCostSavingSummary.
        :type: datetime
        """
        self._time_ended = time_ended

    @property
    def is_cpu_autoscale(self):
        """
        Gets the is_cpu_autoscale of this EstimateCostSavingSummary.
        Indicates if CPU autoscaling is applied.


        :return: The is_cpu_autoscale of this EstimateCostSavingSummary.
        :rtype: bool
        """
        return self._is_cpu_autoscale

    @is_cpu_autoscale.setter
    def is_cpu_autoscale(self, is_cpu_autoscale):
        """
        Sets the is_cpu_autoscale of this EstimateCostSavingSummary.
        Indicates if CPU autoscaling is applied.


        :param is_cpu_autoscale: The is_cpu_autoscale of this EstimateCostSavingSummary.
        :type: bool
        """
        self._is_cpu_autoscale = is_cpu_autoscale

    @property
    def estimated_usage_without_elastic_pool(self):
        """
        Gets the estimated_usage_without_elastic_pool of this EstimateCostSavingSummary.
        CPU cost for a given time period under regular billing plan, in ECPU hours.


        :return: The estimated_usage_without_elastic_pool of this EstimateCostSavingSummary.
        :rtype: int
        """
        return self._estimated_usage_without_elastic_pool

    @estimated_usage_without_elastic_pool.setter
    def estimated_usage_without_elastic_pool(self, estimated_usage_without_elastic_pool):
        """
        Sets the estimated_usage_without_elastic_pool of this EstimateCostSavingSummary.
        CPU cost for a given time period under regular billing plan, in ECPU hours.


        :param estimated_usage_without_elastic_pool: The estimated_usage_without_elastic_pool of this EstimateCostSavingSummary.
        :type: int
        """
        self._estimated_usage_without_elastic_pool = estimated_usage_without_elastic_pool

    @property
    def usage_with_elastic_pool(self):
        """
        Gets the usage_with_elastic_pool of this EstimateCostSavingSummary.
        CPU cost for a given time period under elastic pool billing plan, in ECPU hours.


        :return: The usage_with_elastic_pool of this EstimateCostSavingSummary.
        :rtype: int
        """
        return self._usage_with_elastic_pool

    @usage_with_elastic_pool.setter
    def usage_with_elastic_pool(self, usage_with_elastic_pool):
        """
        Sets the usage_with_elastic_pool of this EstimateCostSavingSummary.
        CPU cost for a given time period under elastic pool billing plan, in ECPU hours.


        :param usage_with_elastic_pool: The usage_with_elastic_pool of this EstimateCostSavingSummary.
        :type: int
        """
        self._usage_with_elastic_pool = usage_with_elastic_pool

    @property
    def cost_savings_with_elastic_pool(self):
        """
        Gets the cost_savings_with_elastic_pool of this EstimateCostSavingSummary.
        Estimated cost savings in percentage with elastic pool utilization.


        :return: The cost_savings_with_elastic_pool of this EstimateCostSavingSummary.
        :rtype: float
        """
        return self._cost_savings_with_elastic_pool

    @cost_savings_with_elastic_pool.setter
    def cost_savings_with_elastic_pool(self, cost_savings_with_elastic_pool):
        """
        Sets the cost_savings_with_elastic_pool of this EstimateCostSavingSummary.
        Estimated cost savings in percentage with elastic pool utilization.


        :param cost_savings_with_elastic_pool: The cost_savings_with_elastic_pool of this EstimateCostSavingSummary.
        :type: float
        """
        self._cost_savings_with_elastic_pool = cost_savings_with_elastic_pool

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
