# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HaMetricDefinition(object):
    """
    The metric definition for HA and backup metrics.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new HaMetricDefinition object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param metric_name:
            The value to assign to the metric_name property of this HaMetricDefinition.
        :type metric_name: str

        :param metadata:
            The value to assign to the metadata property of this HaMetricDefinition.
        :type metadata: dict(str, str)

        :param dimensions:
            The value to assign to the dimensions property of this HaMetricDefinition.
        :type dimensions: dict(str, str)

        :param timestamp:
            The value to assign to the timestamp property of this HaMetricDefinition.
        :type timestamp: datetime

        :param value:
            The value to assign to the value property of this HaMetricDefinition.
        :type value: float

        """
        self.swagger_types = {
            'metric_name': 'str',
            'metadata': 'dict(str, str)',
            'dimensions': 'dict(str, str)',
            'timestamp': 'datetime',
            'value': 'float'
        }
        self.attribute_map = {
            'metric_name': 'metricName',
            'metadata': 'metadata',
            'dimensions': 'dimensions',
            'timestamp': 'timestamp',
            'value': 'value'
        }
        self._metric_name = None
        self._metadata = None
        self._dimensions = None
        self._timestamp = None
        self._value = None

    @property
    def metric_name(self):
        """
        **[Required]** Gets the metric_name of this HaMetricDefinition.
        The name of the metric.


        :return: The metric_name of this HaMetricDefinition.
        :rtype: str
        """
        return self._metric_name

    @metric_name.setter
    def metric_name(self, metric_name):
        """
        Sets the metric_name of this HaMetricDefinition.
        The name of the metric.


        :param metric_name: The metric_name of this HaMetricDefinition.
        :type: str
        """
        self._metric_name = metric_name

    @property
    def metadata(self):
        """
        **[Required]** Gets the metadata of this HaMetricDefinition.
        The metadata qualifiers provided in the definition of the returned metric.
        Available metadata vary by metric.


        :return: The metadata of this HaMetricDefinition.
        :rtype: dict(str, str)
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """
        Sets the metadata of this HaMetricDefinition.
        The metadata qualifiers provided in the definition of the returned metric.
        Available metadata vary by metric.


        :param metadata: The metadata of this HaMetricDefinition.
        :type: dict(str, str)
        """
        self._metadata = metadata

    @property
    def dimensions(self):
        """
        **[Required]** Gets the dimensions of this HaMetricDefinition.
        The dimension qualifiers provided in the definition of the returned metric.
        Available dimensions vary by metric namespace. Each dimension takes the form of a key-value pair.
        Example: `{\"resourceId\": \"ocid1.instance.region1.phx.exampleuniqueID\"}`


        :return: The dimensions of this HaMetricDefinition.
        :rtype: dict(str, str)
        """
        return self._dimensions

    @dimensions.setter
    def dimensions(self, dimensions):
        """
        Sets the dimensions of this HaMetricDefinition.
        The dimension qualifiers provided in the definition of the returned metric.
        Available dimensions vary by metric namespace. Each dimension takes the form of a key-value pair.
        Example: `{\"resourceId\": \"ocid1.instance.region1.phx.exampleuniqueID\"}`


        :param dimensions: The dimensions of this HaMetricDefinition.
        :type: dict(str, str)
        """
        self._dimensions = dimensions

    @property
    def timestamp(self):
        """
        **[Required]** Gets the timestamp of this HaMetricDefinition.
        The data point date and time in UTC in ISO-8601 format, which is \"yyyy-MM-dd'T'hh:mm:ss.sss'Z'\".


        :return: The timestamp of this HaMetricDefinition.
        :rtype: datetime
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """
        Sets the timestamp of this HaMetricDefinition.
        The data point date and time in UTC in ISO-8601 format, which is \"yyyy-MM-dd'T'hh:mm:ss.sss'Z'\".


        :param timestamp: The timestamp of this HaMetricDefinition.
        :type: datetime
        """
        self._timestamp = timestamp

    @property
    def value(self):
        """
        **[Required]** Gets the value of this HaMetricDefinition.
        The target value of the metric.


        :return: The value of this HaMetricDefinition.
        :rtype: float
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this HaMetricDefinition.
        The target value of the metric.


        :param value: The value of this HaMetricDefinition.
        :type: float
        """
        self._value = value

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
