# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MySqlQueryExplainPlan(object):
    """
    The explain plan for a given MySQL query.
    """

    #: A constant which can be used with the json_explain_version property of a MySqlQueryExplainPlan.
    #: This constant has a value of "V1"
    JSON_EXPLAIN_VERSION_V1 = "V1"

    #: A constant which can be used with the json_explain_version property of a MySqlQueryExplainPlan.
    #: This constant has a value of "V2"
    JSON_EXPLAIN_VERSION_V2 = "V2"

    def __init__(self, **kwargs):
        """
        Initializes a new MySqlQueryExplainPlan object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param json_explain:
            The value to assign to the json_explain property of this MySqlQueryExplainPlan.
        :type json_explain: str

        :param json_explain_version:
            The value to assign to the json_explain_version property of this MySqlQueryExplainPlan.
            Allowed values for this property are: "V1", "V2", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type json_explain_version: str

        """
        self.swagger_types = {
            'json_explain': 'str',
            'json_explain_version': 'str'
        }
        self.attribute_map = {
            'json_explain': 'jsonExplain',
            'json_explain_version': 'jsonExplainVersion'
        }
        self._json_explain = None
        self._json_explain_version = None

    @property
    def json_explain(self):
        """
        **[Required]** Gets the json_explain of this MySqlQueryExplainPlan.
        The json format of the explain plan.


        :return: The json_explain of this MySqlQueryExplainPlan.
        :rtype: str
        """
        return self._json_explain

    @json_explain.setter
    def json_explain(self, json_explain):
        """
        Sets the json_explain of this MySqlQueryExplainPlan.
        The json format of the explain plan.


        :param json_explain: The json_explain of this MySqlQueryExplainPlan.
        :type: str
        """
        self._json_explain = json_explain

    @property
    def json_explain_version(self):
        """
        **[Required]** Gets the json_explain_version of this MySqlQueryExplainPlan.
        The version of the Json format of MySQL Explain.

        Allowed values for this property are: "V1", "V2", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The json_explain_version of this MySqlQueryExplainPlan.
        :rtype: str
        """
        return self._json_explain_version

    @json_explain_version.setter
    def json_explain_version(self, json_explain_version):
        """
        Sets the json_explain_version of this MySqlQueryExplainPlan.
        The version of the Json format of MySQL Explain.


        :param json_explain_version: The json_explain_version of this MySqlQueryExplainPlan.
        :type: str
        """
        allowed_values = ["V1", "V2"]
        if not value_allowed_none_or_none_sentinel(json_explain_version, allowed_values):
            json_explain_version = 'UNKNOWN_ENUM_VALUE'
        self._json_explain_version = json_explain_version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
