# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateNamedCredentialDetails(object):
    """
    The details required to update a named credential.
    """

    #: A constant which can be used with the scope property of a UpdateNamedCredentialDetails.
    #: This constant has a value of "RESOURCE"
    SCOPE_RESOURCE = "RESOURCE"

    #: A constant which can be used with the scope property of a UpdateNamedCredentialDetails.
    #: This constant has a value of "GLOBAL"
    SCOPE_GLOBAL = "GLOBAL"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateNamedCredentialDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param description:
            The value to assign to the description property of this UpdateNamedCredentialDetails.
        :type description: str

        :param scope:
            The value to assign to the scope property of this UpdateNamedCredentialDetails.
            Allowed values for this property are: "RESOURCE", "GLOBAL"
        :type scope: str

        :param content:
            The value to assign to the content property of this UpdateNamedCredentialDetails.
        :type content: oci.database_management.models.NamedCredentialContent

        :param associated_resource:
            The value to assign to the associated_resource property of this UpdateNamedCredentialDetails.
        :type associated_resource: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateNamedCredentialDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateNamedCredentialDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'description': 'str',
            'scope': 'str',
            'content': 'NamedCredentialContent',
            'associated_resource': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'description': 'description',
            'scope': 'scope',
            'content': 'content',
            'associated_resource': 'associatedResource',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._description = None
        self._scope = None
        self._content = None
        self._associated_resource = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def description(self):
        """
        Gets the description of this UpdateNamedCredentialDetails.
        The information specified by the user about the named credential.


        :return: The description of this UpdateNamedCredentialDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateNamedCredentialDetails.
        The information specified by the user about the named credential.


        :param description: The description of this UpdateNamedCredentialDetails.
        :type: str
        """
        self._description = description

    @property
    def scope(self):
        """
        Gets the scope of this UpdateNamedCredentialDetails.
        The scope of the named credential.

        Allowed values for this property are: "RESOURCE", "GLOBAL"


        :return: The scope of this UpdateNamedCredentialDetails.
        :rtype: str
        """
        return self._scope

    @scope.setter
    def scope(self, scope):
        """
        Sets the scope of this UpdateNamedCredentialDetails.
        The scope of the named credential.


        :param scope: The scope of this UpdateNamedCredentialDetails.
        :type: str
        """
        allowed_values = ["RESOURCE", "GLOBAL"]
        if not value_allowed_none_or_none_sentinel(scope, allowed_values):
            raise ValueError(
                f"Invalid value for `scope`, must be None or one of {allowed_values}"
            )
        self._scope = scope

    @property
    def content(self):
        """
        Gets the content of this UpdateNamedCredentialDetails.

        :return: The content of this UpdateNamedCredentialDetails.
        :rtype: oci.database_management.models.NamedCredentialContent
        """
        return self._content

    @content.setter
    def content(self, content):
        """
        Sets the content of this UpdateNamedCredentialDetails.

        :param content: The content of this UpdateNamedCredentialDetails.
        :type: oci.database_management.models.NamedCredentialContent
        """
        self._content = content

    @property
    def associated_resource(self):
        """
        Gets the associated_resource of this UpdateNamedCredentialDetails.
        The `OCID`__ of the resource that
        is associated to the named credential.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The associated_resource of this UpdateNamedCredentialDetails.
        :rtype: str
        """
        return self._associated_resource

    @associated_resource.setter
    def associated_resource(self, associated_resource):
        """
        Sets the associated_resource of this UpdateNamedCredentialDetails.
        The `OCID`__ of the resource that
        is associated to the named credential.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param associated_resource: The associated_resource of this UpdateNamedCredentialDetails.
        :type: str
        """
        self._associated_resource = associated_resource

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateNamedCredentialDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdateNamedCredentialDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateNamedCredentialDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdateNamedCredentialDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateNamedCredentialDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdateNamedCredentialDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateNamedCredentialDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdateNamedCredentialDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
