# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230518


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CollectTracesData(object):
    """
    Information regarding the DB trace and alert log collection
    """

    #: A constant which can be used with the collect_traces_state property of a CollectTracesData.
    #: This constant has a value of "IN_PROGRESS"
    COLLECT_TRACES_STATE_IN_PROGRESS = "IN_PROGRESS"

    #: A constant which can be used with the collect_traces_state property of a CollectTracesData.
    #: This constant has a value of "SUCCEEDED"
    COLLECT_TRACES_STATE_SUCCEEDED = "SUCCEEDED"

    #: A constant which can be used with the collect_traces_state property of a CollectTracesData.
    #: This constant has a value of "FAILED"
    COLLECT_TRACES_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new CollectTracesData object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param bucket_name:
            The value to assign to the bucket_name property of this CollectTracesData.
        :type bucket_name: str

        :param namespace:
            The value to assign to the namespace property of this CollectTracesData.
        :type namespace: str

        :param object_name:
            The value to assign to the object_name property of this CollectTracesData.
        :type object_name: str

        :param collect_traces_state:
            The value to assign to the collect_traces_state property of this CollectTracesData.
            Allowed values for this property are: "IN_PROGRESS", "SUCCEEDED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type collect_traces_state: str

        """
        self.swagger_types = {
            'bucket_name': 'str',
            'namespace': 'str',
            'object_name': 'str',
            'collect_traces_state': 'str'
        }
        self.attribute_map = {
            'bucket_name': 'bucketName',
            'namespace': 'namespace',
            'object_name': 'objectName',
            'collect_traces_state': 'collectTracesState'
        }
        self._bucket_name = None
        self._namespace = None
        self._object_name = None
        self._collect_traces_state = None

    @property
    def bucket_name(self):
        """
        **[Required]** Gets the bucket_name of this CollectTracesData.
        Name of the bucket containing the file.


        :return: The bucket_name of this CollectTracesData.
        :rtype: str
        """
        return self._bucket_name

    @bucket_name.setter
    def bucket_name(self, bucket_name):
        """
        Sets the bucket_name of this CollectTracesData.
        Name of the bucket containing the file.


        :param bucket_name: The bucket_name of this CollectTracesData.
        :type: str
        """
        self._bucket_name = bucket_name

    @property
    def namespace(self):
        """
        **[Required]** Gets the namespace of this CollectTracesData.
        Object Storage namespace.


        :return: The namespace of this CollectTracesData.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """
        Sets the namespace of this CollectTracesData.
        Object Storage namespace.


        :param namespace: The namespace of this CollectTracesData.
        :type: str
        """
        self._namespace = namespace

    @property
    def object_name(self):
        """
        **[Required]** Gets the object_name of this CollectTracesData.
        Object name.


        :return: The object_name of this CollectTracesData.
        :rtype: str
        """
        return self._object_name

    @object_name.setter
    def object_name(self, object_name):
        """
        Sets the object_name of this CollectTracesData.
        Object name.


        :param object_name: The object_name of this CollectTracesData.
        :type: str
        """
        self._object_name = object_name

    @property
    def collect_traces_state(self):
        """
        **[Required]** Gets the collect_traces_state of this CollectTracesData.
        Status of trace collection process.

        Allowed values for this property are: "IN_PROGRESS", "SUCCEEDED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The collect_traces_state of this CollectTracesData.
        :rtype: str
        """
        return self._collect_traces_state

    @collect_traces_state.setter
    def collect_traces_state(self, collect_traces_state):
        """
        Sets the collect_traces_state of this CollectTracesData.
        Status of trace collection process.


        :param collect_traces_state: The collect_traces_state of this CollectTracesData.
        :type: str
        """
        allowed_values = ["IN_PROGRESS", "SUCCEEDED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(collect_traces_state, allowed_values):
            collect_traces_state = 'UNKNOWN_ENUM_VALUE'
        self._collect_traces_state = collect_traces_state

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
