# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201005


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ValidationIdentityStatus(object):
    """
    Status details for an identity type
    """

    #: A constant which can be used with the type property of a ValidationIdentityStatus.
    #: This constant has a value of "ORACLE_DATABASE_RESOURCE_PRINCIPAL"
    TYPE_ORACLE_DATABASE_RESOURCE_PRINCIPAL = "ORACLE_DATABASE_RESOURCE_PRINCIPAL"

    #: A constant which can be used with the status property of a ValidationIdentityStatus.
    #: This constant has a value of "AVAILABLE"
    STATUS_AVAILABLE = "AVAILABLE"

    #: A constant which can be used with the status property of a ValidationIdentityStatus.
    #: This constant has a value of "UNAVAILABLE"
    STATUS_UNAVAILABLE = "UNAVAILABLE"

    def __init__(self, **kwargs):
        """
        Initializes a new ValidationIdentityStatus object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this ValidationIdentityStatus.
            Allowed values for this property are: "ORACLE_DATABASE_RESOURCE_PRINCIPAL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param status:
            The value to assign to the status property of this ValidationIdentityStatus.
            Allowed values for this property are: "AVAILABLE", "UNAVAILABLE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param status_details:
            The value to assign to the status_details property of this ValidationIdentityStatus.
        :type status_details: str

        """
        self.swagger_types = {
            'type': 'str',
            'status': 'str',
            'status_details': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'status': 'status',
            'status_details': 'statusDetails'
        }
        self._type = None
        self._status = None
        self._status_details = None

    @property
    def type(self):
        """
        Gets the type of this ValidationIdentityStatus.
        The Database Tools identity type.

        Allowed values for this property are: "ORACLE_DATABASE_RESOURCE_PRINCIPAL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this ValidationIdentityStatus.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this ValidationIdentityStatus.
        The Database Tools identity type.


        :param type: The type of this ValidationIdentityStatus.
        :type: str
        """
        allowed_values = ["ORACLE_DATABASE_RESOURCE_PRINCIPAL"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def status(self):
        """
        Gets the status of this ValidationIdentityStatus.
        The status of the identity. AVAILABLE if the identity type can be used with this connection. UNAVAILABLE if not.

        Allowed values for this property are: "AVAILABLE", "UNAVAILABLE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this ValidationIdentityStatus.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this ValidationIdentityStatus.
        The status of the identity. AVAILABLE if the identity type can be used with this connection. UNAVAILABLE if not.


        :param status: The status of this ValidationIdentityStatus.
        :type: str
        """
        allowed_values = ["AVAILABLE", "UNAVAILABLE"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def status_details(self):
        """
        Gets the status_details of this ValidationIdentityStatus.
        If the status is UNAVAILABLE this displays the cause.


        :return: The status_details of this ValidationIdentityStatus.
        :rtype: str
        """
        return self._status_details

    @status_details.setter
    def status_details(self, status_details):
        """
        Sets the status_details of this ValidationIdentityStatus.
        If the status is UNAVAILABLE this displays the cause.


        :param status_details: The status_details of this ValidationIdentityStatus.
        :type: str
        """
        self._status_details = status_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
