# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240102


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AggregatedVulnerabilitySummary(object):
    """
    Singular information of an aggregated vulnerability datapoint.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AggregatedVulnerabilitySummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param timestamp:
            The value to assign to the timestamp property of this AggregatedVulnerabilitySummary.
        :type timestamp: datetime

        :param vulnerabilities_count:
            The value to assign to the vulnerabilities_count property of this AggregatedVulnerabilitySummary.
        :type vulnerabilities_count: int

        :param registered_resources_count:
            The value to assign to the registered_resources_count property of this AggregatedVulnerabilitySummary.
        :type registered_resources_count: int

        """
        self.swagger_types = {
            'timestamp': 'datetime',
            'vulnerabilities_count': 'int',
            'registered_resources_count': 'int'
        }
        self.attribute_map = {
            'timestamp': 'timestamp',
            'vulnerabilities_count': 'vulnerabilitiesCount',
            'registered_resources_count': 'registeredResourcesCount'
        }
        self._timestamp = None
        self._vulnerabilities_count = None
        self._registered_resources_count = None

    @property
    def timestamp(self):
        """
        **[Required]** Gets the timestamp of this AggregatedVulnerabilitySummary.
        UTC timestamp when the scan completed.


        :return: The timestamp of this AggregatedVulnerabilitySummary.
        :rtype: datetime
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """
        Sets the timestamp of this AggregatedVulnerabilitySummary.
        UTC timestamp when the scan completed.


        :param timestamp: The timestamp of this AggregatedVulnerabilitySummary.
        :type: datetime
        """
        self._timestamp = timestamp

    @property
    def vulnerabilities_count(self):
        """
        **[Required]** Gets the vulnerabilities_count of this AggregatedVulnerabilitySummary.
        Unresolved vulnerabilities that were found by the scan.


        :return: The vulnerabilities_count of this AggregatedVulnerabilitySummary.
        :rtype: int
        """
        return self._vulnerabilities_count

    @vulnerabilities_count.setter
    def vulnerabilities_count(self, vulnerabilities_count):
        """
        Sets the vulnerabilities_count of this AggregatedVulnerabilitySummary.
        Unresolved vulnerabilities that were found by the scan.


        :param vulnerabilities_count: The vulnerabilities_count of this AggregatedVulnerabilitySummary.
        :type: int
        """
        self._vulnerabilities_count = vulnerabilities_count

    @property
    def registered_resources_count(self):
        """
        **[Required]** Gets the registered_resources_count of this AggregatedVulnerabilitySummary.
        Registered databases against which the scan ran.


        :return: The registered_resources_count of this AggregatedVulnerabilitySummary.
        :rtype: int
        """
        return self._registered_resources_count

    @registered_resources_count.setter
    def registered_resources_count(self, registered_resources_count):
        """
        Sets the registered_resources_count of this AggregatedVulnerabilitySummary.
        Registered databases against which the scan ran.


        :param registered_resources_count: The registered_resources_count of this AggregatedVulnerabilitySummary.
        :type: int
        """
        self._registered_resources_count = registered_resources_count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
