# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230801


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DelegationControlSummary(object):
    """
    Summary of the Delegation Control.
    """

    #: A constant which can be used with the resource_type property of a DelegationControlSummary.
    #: This constant has a value of "VMCLUSTER"
    RESOURCE_TYPE_VMCLUSTER = "VMCLUSTER"

    #: A constant which can be used with the resource_type property of a DelegationControlSummary.
    #: This constant has a value of "CLOUDVMCLUSTER"
    RESOURCE_TYPE_CLOUDVMCLUSTER = "CLOUDVMCLUSTER"

    def __init__(self, **kwargs):
        """
        Initializes a new DelegationControlSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this DelegationControlSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this DelegationControlSummary.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this DelegationControlSummary.
        :type compartment_id: str

        :param resource_type:
            The value to assign to the resource_type property of this DelegationControlSummary.
            Allowed values for this property are: "VMCLUSTER", "CLOUDVMCLUSTER", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type resource_type: str

        :param time_created:
            The value to assign to the time_created property of this DelegationControlSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this DelegationControlSummary.
        :type time_updated: datetime

        :param time_deleted:
            The value to assign to the time_deleted property of this DelegationControlSummary.
        :type time_deleted: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this DelegationControlSummary.
        :type lifecycle_state: str

        :param lifecycle_state_details:
            The value to assign to the lifecycle_state_details property of this DelegationControlSummary.
        :type lifecycle_state_details: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this DelegationControlSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this DelegationControlSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this DelegationControlSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'resource_type': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'time_deleted': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_state_details': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'resource_type': 'resourceType',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'time_deleted': 'timeDeleted',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_state_details': 'lifecycleStateDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._compartment_id = None
        self._resource_type = None
        self._time_created = None
        self._time_updated = None
        self._time_deleted = None
        self._lifecycle_state = None
        self._lifecycle_state_details = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this DelegationControlSummary.
        The OCID of the Delegation Control.


        :return: The id of this DelegationControlSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DelegationControlSummary.
        The OCID of the Delegation Control.


        :param id: The id of this DelegationControlSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this DelegationControlSummary.
        Name of the Delegation Control. The name does not need to be unique.


        :return: The display_name of this DelegationControlSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this DelegationControlSummary.
        Name of the Delegation Control. The name does not need to be unique.


        :param display_name: The display_name of this DelegationControlSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this DelegationControlSummary.
        The OCID of the compartment that contains the Delegation Control.


        :return: The compartment_id of this DelegationControlSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this DelegationControlSummary.
        The OCID of the compartment that contains the Delegation Control.


        :param compartment_id: The compartment_id of this DelegationControlSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def resource_type(self):
        """
        **[Required]** Gets the resource_type of this DelegationControlSummary.
        resourceType for which the Delegation Control is applicable

        Allowed values for this property are: "VMCLUSTER", "CLOUDVMCLUSTER", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The resource_type of this DelegationControlSummary.
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """
        Sets the resource_type of this DelegationControlSummary.
        resourceType for which the Delegation Control is applicable


        :param resource_type: The resource_type of this DelegationControlSummary.
        :type: str
        """
        allowed_values = ["VMCLUSTER", "CLOUDVMCLUSTER"]
        if not value_allowed_none_or_none_sentinel(resource_type, allowed_values):
            resource_type = 'UNKNOWN_ENUM_VALUE'
        self._resource_type = resource_type

    @property
    def time_created(self):
        """
        Gets the time_created of this DelegationControlSummary.
        Time when the Delegation Control was created, expressed in `RFC 3339]`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this DelegationControlSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this DelegationControlSummary.
        Time when the Delegation Control was created, expressed in `RFC 3339]`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'.

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this DelegationControlSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this DelegationControlSummary.
        Time when the Delegation Control was last modified, expressed in `RFC 3339]`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this DelegationControlSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this DelegationControlSummary.
        Time when the Delegation Control was last modified, expressed in `RFC 3339]`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'.

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this DelegationControlSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def time_deleted(self):
        """
        Gets the time_deleted of this DelegationControlSummary.
        Time when the Delegation Control was deleted, expressed in `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_deleted of this DelegationControlSummary.
        :rtype: datetime
        """
        return self._time_deleted

    @time_deleted.setter
    def time_deleted(self, time_deleted):
        """
        Sets the time_deleted of this DelegationControlSummary.
        Time when the Delegation Control was deleted, expressed in `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'.

        __ https://tools.ietf.org/html/rfc3339


        :param time_deleted: The time_deleted of this DelegationControlSummary.
        :type: datetime
        """
        self._time_deleted = time_deleted

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this DelegationControlSummary.
        The current lifecycle state of the Delegation Control.


        :return: The lifecycle_state of this DelegationControlSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this DelegationControlSummary.
        The current lifecycle state of the Delegation Control.


        :param lifecycle_state: The lifecycle_state of this DelegationControlSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_state_details(self):
        """
        Gets the lifecycle_state_details of this DelegationControlSummary.
        Description of the current lifecycle state in more detail.


        :return: The lifecycle_state_details of this DelegationControlSummary.
        :rtype: str
        """
        return self._lifecycle_state_details

    @lifecycle_state_details.setter
    def lifecycle_state_details(self, lifecycle_state_details):
        """
        Sets the lifecycle_state_details of this DelegationControlSummary.
        Description of the current lifecycle state in more detail.


        :param lifecycle_state_details: The lifecycle_state_details of this DelegationControlSummary.
        :type: str
        """
        self._lifecycle_state_details = lifecycle_state_details

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this DelegationControlSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this DelegationControlSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this DelegationControlSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this DelegationControlSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this DelegationControlSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this DelegationControlSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this DelegationControlSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this DelegationControlSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this DelegationControlSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this DelegationControlSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this DelegationControlSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this DelegationControlSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
