# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HelmDiffArgument(object):
    """
    Parameters for all the helm stages passed for retrieving Helm Diff
    """

    def __init__(self, **kwargs):
        """
        Initializes a new HelmDiffArgument object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param stage_id:
            The value to assign to the stage_id property of this HelmDiffArgument.
        :type stage_id: str

        :param helm_arg_set_values:
            The value to assign to the helm_arg_set_values property of this HelmDiffArgument.
        :type helm_arg_set_values: oci.devops.models.HelmSetValueCollection

        :param helm_arg_string_values:
            The value to assign to the helm_arg_string_values property of this HelmDiffArgument.
        :type helm_arg_string_values: oci.devops.models.HelmSetValueCollection

        :param value_artifact_contents:
            The value to assign to the value_artifact_contents property of this HelmDiffArgument.
        :type value_artifact_contents: oci.devops.models.ValueArtifactContentCollection

        :param helm_stage_contents:
            The value to assign to the helm_stage_contents property of this HelmDiffArgument.
        :type helm_stage_contents: list[oci.devops.models.HelmStageContent]

        """
        self.swagger_types = {
            'stage_id': 'str',
            'helm_arg_set_values': 'HelmSetValueCollection',
            'helm_arg_string_values': 'HelmSetValueCollection',
            'value_artifact_contents': 'ValueArtifactContentCollection',
            'helm_stage_contents': 'list[HelmStageContent]'
        }
        self.attribute_map = {
            'stage_id': 'stageId',
            'helm_arg_set_values': 'helmArgSetValues',
            'helm_arg_string_values': 'helmArgStringValues',
            'value_artifact_contents': 'valueArtifactContents',
            'helm_stage_contents': 'helmStageContents'
        }
        self._stage_id = None
        self._helm_arg_set_values = None
        self._helm_arg_string_values = None
        self._value_artifact_contents = None
        self._helm_stage_contents = None

    @property
    def stage_id(self):
        """
        Gets the stage_id of this HelmDiffArgument.
        Deploy Stage OCID.


        :return: The stage_id of this HelmDiffArgument.
        :rtype: str
        """
        return self._stage_id

    @stage_id.setter
    def stage_id(self, stage_id):
        """
        Sets the stage_id of this HelmDiffArgument.
        Deploy Stage OCID.


        :param stage_id: The stage_id of this HelmDiffArgument.
        :type: str
        """
        self._stage_id = stage_id

    @property
    def helm_arg_set_values(self):
        """
        Gets the helm_arg_set_values of this HelmDiffArgument.

        :return: The helm_arg_set_values of this HelmDiffArgument.
        :rtype: oci.devops.models.HelmSetValueCollection
        """
        return self._helm_arg_set_values

    @helm_arg_set_values.setter
    def helm_arg_set_values(self, helm_arg_set_values):
        """
        Sets the helm_arg_set_values of this HelmDiffArgument.

        :param helm_arg_set_values: The helm_arg_set_values of this HelmDiffArgument.
        :type: oci.devops.models.HelmSetValueCollection
        """
        self._helm_arg_set_values = helm_arg_set_values

    @property
    def helm_arg_string_values(self):
        """
        Gets the helm_arg_string_values of this HelmDiffArgument.

        :return: The helm_arg_string_values of this HelmDiffArgument.
        :rtype: oci.devops.models.HelmSetValueCollection
        """
        return self._helm_arg_string_values

    @helm_arg_string_values.setter
    def helm_arg_string_values(self, helm_arg_string_values):
        """
        Sets the helm_arg_string_values of this HelmDiffArgument.

        :param helm_arg_string_values: The helm_arg_string_values of this HelmDiffArgument.
        :type: oci.devops.models.HelmSetValueCollection
        """
        self._helm_arg_string_values = helm_arg_string_values

    @property
    def value_artifact_contents(self):
        """
        Gets the value_artifact_contents of this HelmDiffArgument.

        :return: The value_artifact_contents of this HelmDiffArgument.
        :rtype: oci.devops.models.ValueArtifactContentCollection
        """
        return self._value_artifact_contents

    @value_artifact_contents.setter
    def value_artifact_contents(self, value_artifact_contents):
        """
        Sets the value_artifact_contents of this HelmDiffArgument.

        :param value_artifact_contents: The value_artifact_contents of this HelmDiffArgument.
        :type: oci.devops.models.ValueArtifactContentCollection
        """
        self._value_artifact_contents = value_artifact_contents

    @property
    def helm_stage_contents(self):
        """
        Gets the helm_stage_contents of this HelmDiffArgument.
        Stage specific values along with the helm chart injected by Shepherd


        :return: The helm_stage_contents of this HelmDiffArgument.
        :rtype: list[oci.devops.models.HelmStageContent]
        """
        return self._helm_stage_contents

    @helm_stage_contents.setter
    def helm_stage_contents(self, helm_stage_contents):
        """
        Sets the helm_stage_contents of this HelmDiffArgument.
        Stage specific values along with the helm chart injected by Shepherd


        :param helm_stage_contents: The helm_stage_contents of this HelmDiffArgument.
        :type: list[oci.devops.models.HelmStageContent]
        """
        self._helm_stage_contents = helm_stage_contents

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
