# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AdbArtifactsDetail(object):
    """
    ADW details to upload artifacts.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AdbArtifactsDetail object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param instance_id:
            The value to assign to the instance_id property of this AdbArtifactsDetail.
        :type instance_id: str

        :param artifact_object_storage_path:
            The value to assign to the artifact_object_storage_path property of this AdbArtifactsDetail.
        :type artifact_object_storage_path: str

        :param db_credentials:
            The value to assign to the db_credentials property of this AdbArtifactsDetail.
        :type db_credentials: list[oci.dif.models.DbCredentialsDetail]

        """
        self.swagger_types = {
            'instance_id': 'str',
            'artifact_object_storage_path': 'str',
            'db_credentials': 'list[DbCredentialsDetail]'
        }
        self.attribute_map = {
            'instance_id': 'instanceId',
            'artifact_object_storage_path': 'artifactObjectStoragePath',
            'db_credentials': 'dbCredentials'
        }
        self._instance_id = None
        self._artifact_object_storage_path = None
        self._db_credentials = None

    @property
    def instance_id(self):
        """
        **[Required]** Gets the instance_id of this AdbArtifactsDetail.
        Instance id of the existing ADB instance.


        :return: The instance_id of this AdbArtifactsDetail.
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """
        Sets the instance_id of this AdbArtifactsDetail.
        Instance id of the existing ADB instance.


        :param instance_id: The instance_id of this AdbArtifactsDetail.
        :type: str
        """
        self._instance_id = instance_id

    @property
    def artifact_object_storage_path(self):
        """
        **[Required]** Gets the artifact_object_storage_path of this AdbArtifactsDetail.
        Object storage path for the artifacts.


        :return: The artifact_object_storage_path of this AdbArtifactsDetail.
        :rtype: str
        """
        return self._artifact_object_storage_path

    @artifact_object_storage_path.setter
    def artifact_object_storage_path(self, artifact_object_storage_path):
        """
        Sets the artifact_object_storage_path of this AdbArtifactsDetail.
        Object storage path for the artifacts.


        :param artifact_object_storage_path: The artifact_object_storage_path of this AdbArtifactsDetail.
        :type: str
        """
        self._artifact_object_storage_path = artifact_object_storage_path

    @property
    def db_credentials(self):
        """
        Gets the db_credentials of this AdbArtifactsDetail.
        DB credential details.


        :return: The db_credentials of this AdbArtifactsDetail.
        :rtype: list[oci.dif.models.DbCredentialsDetail]
        """
        return self._db_credentials

    @db_credentials.setter
    def db_credentials(self, db_credentials):
        """
        Sets the db_credentials of this AdbArtifactsDetail.
        DB credential details.


        :param db_credentials: The db_credentials of this AdbArtifactsDetail.
        :type: list[oci.dif.models.DbCredentialsDetail]
        """
        self._db_credentials = db_credentials

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
