# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DbCredentialsDetail(object):
    """
    DB credentials for ADB connection.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DbCredentialsDetail object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param user_name:
            The value to assign to the user_name property of this DbCredentialsDetail.
        :type user_name: str

        :param secret_id:
            The value to assign to the secret_id property of this DbCredentialsDetail.
        :type secret_id: str

        :param user_type:
            The value to assign to the user_type property of this DbCredentialsDetail.
        :type user_type: str

        """
        self.swagger_types = {
            'user_name': 'str',
            'secret_id': 'str',
            'user_type': 'str'
        }
        self.attribute_map = {
            'user_name': 'userName',
            'secret_id': 'secretId',
            'user_type': 'userType'
        }
        self._user_name = None
        self._secret_id = None
        self._user_type = None

    @property
    def user_name(self):
        """
        **[Required]** Gets the user_name of this DbCredentialsDetail.
        Username for ADB to be created or updated.


        :return: The user_name of this DbCredentialsDetail.
        :rtype: str
        """
        return self._user_name

    @user_name.setter
    def user_name(self, user_name):
        """
        Sets the user_name of this DbCredentialsDetail.
        Username for ADB to be created or updated.


        :param user_name: The user_name of this DbCredentialsDetail.
        :type: str
        """
        self._user_name = user_name

    @property
    def secret_id(self):
        """
        **[Required]** Gets the secret_id of this DbCredentialsDetail.
        Vault secret OCID containing the corresponding user password.


        :return: The secret_id of this DbCredentialsDetail.
        :rtype: str
        """
        return self._secret_id

    @secret_id.setter
    def secret_id(self, secret_id):
        """
        Sets the secret_id of this DbCredentialsDetail.
        Vault secret OCID containing the corresponding user password.


        :param secret_id: The secret_id of this DbCredentialsDetail.
        :type: str
        """
        self._secret_id = secret_id

    @property
    def user_type(self):
        """
        **[Required]** Gets the user_type of this DbCredentialsDetail.
        Type of the user. Allowed values are \"ADMIN\" or \"CUSTOM\" or \"GGCS\".


        :return: The user_type of this DbCredentialsDetail.
        :rtype: str
        """
        return self._user_type

    @user_type.setter
    def user_type(self, user_type):
        """
        Sets the user_type of this DbCredentialsDetail.
        Type of the user. Allowed values are \"ADMIN\" or \"CUSTOM\" or \"GGCS\".


        :param user_type: The user_type of this DbCredentialsDetail.
        :type: str
        """
        self._user_type = user_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
