# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OkeDetail(object):
    """
    Details to reference an existing Oracle Kubernetes Engine cluster.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OkeDetail object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param instance_id:
            The value to assign to the instance_id property of this OkeDetail.
        :type instance_id: str

        :param cluster_id:
            The value to assign to the cluster_id property of this OkeDetail.
        :type cluster_id: str

        :param namespace_name:
            The value to assign to the namespace_name property of this OkeDetail.
        :type namespace_name: str

        """
        self.swagger_types = {
            'instance_id': 'str',
            'cluster_id': 'str',
            'namespace_name': 'str'
        }
        self.attribute_map = {
            'instance_id': 'instanceId',
            'cluster_id': 'clusterId',
            'namespace_name': 'namespaceName'
        }
        self._instance_id = None
        self._cluster_id = None
        self._namespace_name = None

    @property
    def instance_id(self):
        """
        **[Required]** Gets the instance_id of this OkeDetail.
        Unique identifier for an oke instance.


        :return: The instance_id of this OkeDetail.
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """
        Sets the instance_id of this OkeDetail.
        Unique identifier for an oke instance.


        :param instance_id: The instance_id of this OkeDetail.
        :type: str
        """
        self._instance_id = instance_id

    @property
    def cluster_id(self):
        """
        **[Required]** Gets the cluster_id of this OkeDetail.
        OCID of existing OKE cluster.


        :return: The cluster_id of this OkeDetail.
        :rtype: str
        """
        return self._cluster_id

    @cluster_id.setter
    def cluster_id(self, cluster_id):
        """
        Sets the cluster_id of this OkeDetail.
        OCID of existing OKE cluster.


        :param cluster_id: The cluster_id of this OkeDetail.
        :type: str
        """
        self._cluster_id = cluster_id

    @property
    def namespace_name(self):
        """
        **[Required]** Gets the namespace_name of this OkeDetail.
        Kubernetes namespace-name of OKE cluster.


        :return: The namespace_name of this OkeDetail.
        :rtype: str
        """
        return self._namespace_name

    @namespace_name.setter
    def namespace_name(self, namespace_name):
        """
        Sets the namespace_name of this OkeDetail.
        Kubernetes namespace-name of OKE cluster.


        :param namespace_name: The namespace_name of this OkeDetail.
        :type: str
        """
        self._namespace_name = namespace_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
