# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OmkDetail(object):
    """
    Details to reference an existing Oracle Managed Kubernetes environment.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OmkDetail object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param instance_id:
            The value to assign to the instance_id property of this OmkDetail.
        :type instance_id: str

        :param cluster_namespace_id:
            The value to assign to the cluster_namespace_id property of this OmkDetail.
        :type cluster_namespace_id: str

        :param cluster_id:
            The value to assign to the cluster_id property of this OmkDetail.
        :type cluster_id: str

        :param namespace_name:
            The value to assign to the namespace_name property of this OmkDetail.
        :type namespace_name: str

        """
        self.swagger_types = {
            'instance_id': 'str',
            'cluster_namespace_id': 'str',
            'cluster_id': 'str',
            'namespace_name': 'str'
        }
        self.attribute_map = {
            'instance_id': 'instanceId',
            'cluster_namespace_id': 'clusterNamespaceId',
            'cluster_id': 'clusterId',
            'namespace_name': 'namespaceName'
        }
        self._instance_id = None
        self._cluster_namespace_id = None
        self._cluster_id = None
        self._namespace_name = None

    @property
    def instance_id(self):
        """
        **[Required]** Gets the instance_id of this OmkDetail.
        Unique identifier for an omk instance.


        :return: The instance_id of this OmkDetail.
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """
        Sets the instance_id of this OmkDetail.
        Unique identifier for an omk instance.


        :param instance_id: The instance_id of this OmkDetail.
        :type: str
        """
        self._instance_id = instance_id

    @property
    def cluster_namespace_id(self):
        """
        **[Required]** Gets the cluster_namespace_id of this OmkDetail.
        OCID of existing OMK cluster-namespace.


        :return: The cluster_namespace_id of this OmkDetail.
        :rtype: str
        """
        return self._cluster_namespace_id

    @cluster_namespace_id.setter
    def cluster_namespace_id(self, cluster_namespace_id):
        """
        Sets the cluster_namespace_id of this OmkDetail.
        OCID of existing OMK cluster-namespace.


        :param cluster_namespace_id: The cluster_namespace_id of this OmkDetail.
        :type: str
        """
        self._cluster_namespace_id = cluster_namespace_id

    @property
    def cluster_id(self):
        """
        **[Required]** Gets the cluster_id of this OmkDetail.
        OCID of cluster assigned to OMK cluster-namespace.


        :return: The cluster_id of this OmkDetail.
        :rtype: str
        """
        return self._cluster_id

    @cluster_id.setter
    def cluster_id(self, cluster_id):
        """
        Sets the cluster_id of this OmkDetail.
        OCID of cluster assigned to OMK cluster-namespace.


        :param cluster_id: The cluster_id of this OmkDetail.
        :type: str
        """
        self._cluster_id = cluster_id

    @property
    def namespace_name(self):
        """
        **[Required]** Gets the namespace_name of this OmkDetail.
        Kubernetes namespace-name of OMK cluster-namespace.


        :return: The namespace_name of this OmkDetail.
        :rtype: str
        """
        return self._namespace_name

    @namespace_name.setter
    def namespace_name(self, namespace_name):
        """
        Sets the namespace_name of this OmkDetail.
        Kubernetes namespace-name of OMK cluster-namespace.


        :param namespace_name: The namespace_name of this OmkDetail.
        :type: str
        """
        self._namespace_name = namespace_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
