# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SecretData(object):
    """
    Maps a kubernetes secret data key to a value sourced from Oci Vault. At deploy time, the platform fetches the secret value by OCID and injects it under the specified key in the secrets data. No plaintext secret values are required in the payload.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SecretData object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param key:
            The value to assign to the key property of this SecretData.
        :type key: str

        :param secret_id:
            The value to assign to the secret_id property of this SecretData.
        :type secret_id: str

        """
        self.swagger_types = {
            'key': 'str',
            'secret_id': 'str'
        }
        self.attribute_map = {
            'key': 'key',
            'secret_id': 'secretId'
        }
        self._key = None
        self._secret_id = None

    @property
    def key(self):
        """
        **[Required]** Gets the key of this SecretData.
        Data key in the kubernetes secret.


        :return: The key of this SecretData.
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """
        Sets the key of this SecretData.
        Data key in the kubernetes secret.


        :param key: The key of this SecretData.
        :type: str
        """
        self._key = key

    @property
    def secret_id(self):
        """
        **[Required]** Gets the secret_id of this SecretData.
        OCID of the Oci vault secret that provides the value for this key. The latest active secret version is used at deploy time unless otherwise configured.


        :return: The secret_id of this SecretData.
        :rtype: str
        """
        return self._secret_id

    @secret_id.setter
    def secret_id(self, secret_id):
        """
        Sets the secret_id of this SecretData.
        OCID of the Oci vault secret that provides the value for this key. The latest active secret version is used at deploy time unless otherwise configured.


        :param secret_id: The secret_id of this SecretData.
        :type: str
        """
        self._secret_id = secret_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
