# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SecretDetail(object):
    """
    Details of the kubernetes secrets to be created or updated.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SecretDetail object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param secret_name:
            The value to assign to the secret_name property of this SecretDetail.
        :type secret_name: str

        :param template_object_storage_path:
            The value to assign to the template_object_storage_path property of this SecretDetail.
        :type template_object_storage_path: str

        :param secret_data:
            The value to assign to the secret_data property of this SecretDetail.
        :type secret_data: list[oci.dif.models.SecretData]

        """
        self.swagger_types = {
            'secret_name': 'str',
            'template_object_storage_path': 'str',
            'secret_data': 'list[SecretData]'
        }
        self.attribute_map = {
            'secret_name': 'secretName',
            'template_object_storage_path': 'templateObjectStoragePath',
            'secret_data': 'secretData'
        }
        self._secret_name = None
        self._template_object_storage_path = None
        self._secret_data = None

    @property
    def secret_name(self):
        """
        **[Required]** Gets the secret_name of this SecretDetail.
        Name of the kubernetes secret of max length 63 and contain only lowercase alphanumeric characters or '-' and start and end with an alphabetic character.


        :return: The secret_name of this SecretDetail.
        :rtype: str
        """
        return self._secret_name

    @secret_name.setter
    def secret_name(self, secret_name):
        """
        Sets the secret_name of this SecretDetail.
        Name of the kubernetes secret of max length 63 and contain only lowercase alphanumeric characters or '-' and start and end with an alphabetic character.


        :param secret_name: The secret_name of this SecretDetail.
        :type: str
        """
        self._secret_name = secret_name

    @property
    def template_object_storage_path(self):
        """
        Gets the template_object_storage_path of this SecretDetail.
        Object storage path for the secret template to be used for creating secret otherwise it will be created with default template.


        :return: The template_object_storage_path of this SecretDetail.
        :rtype: str
        """
        return self._template_object_storage_path

    @template_object_storage_path.setter
    def template_object_storage_path(self, template_object_storage_path):
        """
        Sets the template_object_storage_path of this SecretDetail.
        Object storage path for the secret template to be used for creating secret otherwise it will be created with default template.


        :param template_object_storage_path: The template_object_storage_path of this SecretDetail.
        :type: str
        """
        self._template_object_storage_path = template_object_storage_path

    @property
    def secret_data(self):
        """
        **[Required]** Gets the secret_data of this SecretDetail.
        List of kubernetes secret data.


        :return: The secret_data of this SecretDetail.
        :rtype: list[oci.dif.models.SecretData]
        """
        return self._secret_data

    @secret_data.setter
    def secret_data(self, secret_data):
        """
        Sets the secret_data of this SecretDetail.
        List of kubernetes secret data.


        :param secret_data: The secret_data of this SecretDetail.
        :type: list[oci.dif.models.SecretData]
        """
        self._secret_data = secret_data

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
