# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateVaultAndEncryptionKeyDetails(object):
    """
    Create properties for a customer-managed vault and encryption key in the destination region.
    The customer-managed encryption key in this will be used to encrypt the resource or containing resources after they
    move to the destination region.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateVaultAndEncryptionKeyDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param vault_id:
            The value to assign to the vault_id property of this CreateVaultAndEncryptionKeyDetails.
        :type vault_id: str

        :param encryption_key_id:
            The value to assign to the encryption_key_id property of this CreateVaultAndEncryptionKeyDetails.
        :type encryption_key_id: str

        """
        self.swagger_types = {
            'vault_id': 'str',
            'encryption_key_id': 'str'
        }
        self.attribute_map = {
            'vault_id': 'vaultId',
            'encryption_key_id': 'encryptionKeyId'
        }
        self._vault_id = None
        self._encryption_key_id = None

    @property
    def vault_id(self):
        """
        **[Required]** Gets the vault_id of this CreateVaultAndEncryptionKeyDetails.
        The OCID of the destination region vault for the customer-managed encryption key.

        Example: `ocid1.vault.oc1..uniqueID`


        :return: The vault_id of this CreateVaultAndEncryptionKeyDetails.
        :rtype: str
        """
        return self._vault_id

    @vault_id.setter
    def vault_id(self, vault_id):
        """
        Sets the vault_id of this CreateVaultAndEncryptionKeyDetails.
        The OCID of the destination region vault for the customer-managed encryption key.

        Example: `ocid1.vault.oc1..uniqueID`


        :param vault_id: The vault_id of this CreateVaultAndEncryptionKeyDetails.
        :type: str
        """
        self._vault_id = vault_id

    @property
    def encryption_key_id(self):
        """
        **[Required]** Gets the encryption_key_id of this CreateVaultAndEncryptionKeyDetails.
        The OCID of the customer-managed encryption key in the destination region vault.

        Example: `ocid1.key.oc1..uniqueID`


        :return: The encryption_key_id of this CreateVaultAndEncryptionKeyDetails.
        :rtype: str
        """
        return self._encryption_key_id

    @encryption_key_id.setter
    def encryption_key_id(self, encryption_key_id):
        """
        Sets the encryption_key_id of this CreateVaultAndEncryptionKeyDetails.
        The OCID of the customer-managed encryption key in the destination region vault.

        Example: `ocid1.key.oc1..uniqueID`


        :param encryption_key_id: The encryption_key_id of this CreateVaultAndEncryptionKeyDetails.
        :type: str
        """
        self._encryption_key_id = encryption_key_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
