# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DrPlanExecutionFailedStepStatusCounts(object):
    """
    A summary of steps that failed during a DR plan execution, including failed and timed out steps.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DrPlanExecutionFailedStepStatusCounts object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param total_failed:
            The value to assign to the total_failed property of this DrPlanExecutionFailedStepStatusCounts.
        :type total_failed: int

        :param failed:
            The value to assign to the failed property of this DrPlanExecutionFailedStepStatusCounts.
        :type failed: int

        :param timed_out:
            The value to assign to the timed_out property of this DrPlanExecutionFailedStepStatusCounts.
        :type timed_out: int

        """
        self.swagger_types = {
            'total_failed': 'int',
            'failed': 'int',
            'timed_out': 'int'
        }
        self.attribute_map = {
            'total_failed': 'totalFailed',
            'failed': 'failed',
            'timed_out': 'timedOut'
        }
        self._total_failed = None
        self._failed = None
        self._timed_out = None

    @property
    def total_failed(self):
        """
        **[Required]** Gets the total_failed of this DrPlanExecutionFailedStepStatusCounts.
        The total number of steps that failed during a DR plan execution.


        :return: The total_failed of this DrPlanExecutionFailedStepStatusCounts.
        :rtype: int
        """
        return self._total_failed

    @total_failed.setter
    def total_failed(self, total_failed):
        """
        Sets the total_failed of this DrPlanExecutionFailedStepStatusCounts.
        The total number of steps that failed during a DR plan execution.


        :param total_failed: The total_failed of this DrPlanExecutionFailedStepStatusCounts.
        :type: int
        """
        self._total_failed = total_failed

    @property
    def failed(self):
        """
        **[Required]** Gets the failed of this DrPlanExecutionFailedStepStatusCounts.
        The total number of failed steps in a DR plan execution.


        :return: The failed of this DrPlanExecutionFailedStepStatusCounts.
        :rtype: int
        """
        return self._failed

    @failed.setter
    def failed(self, failed):
        """
        Sets the failed of this DrPlanExecutionFailedStepStatusCounts.
        The total number of failed steps in a DR plan execution.


        :param failed: The failed of this DrPlanExecutionFailedStepStatusCounts.
        :type: int
        """
        self._failed = failed

    @property
    def timed_out(self):
        """
        **[Required]** Gets the timed_out of this DrPlanExecutionFailedStepStatusCounts.
        The total number of steps that timed out during a DR plan execution.


        :return: The timed_out of this DrPlanExecutionFailedStepStatusCounts.
        :rtype: int
        """
        return self._timed_out

    @timed_out.setter
    def timed_out(self, timed_out):
        """
        Sets the timed_out of this DrPlanExecutionFailedStepStatusCounts.
        The total number of steps that timed out during a DR plan execution.


        :param timed_out: The timed_out of this DrPlanExecutionFailedStepStatusCounts.
        :type: int
        """
        self._timed_out = timed_out

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
