# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DrPlanExecutionSkippedStepStatusCounts(object):
    """
    A summary of steps that were skipped during a DR plan execution, including disabled, failed but ignored, timed out but ignored, and canceled steps.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DrPlanExecutionSkippedStepStatusCounts object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param total_skipped:
            The value to assign to the total_skipped property of this DrPlanExecutionSkippedStepStatusCounts.
        :type total_skipped: int

        :param disabled:
            The value to assign to the disabled property of this DrPlanExecutionSkippedStepStatusCounts.
        :type disabled: int

        :param failed_ignored:
            The value to assign to the failed_ignored property of this DrPlanExecutionSkippedStepStatusCounts.
        :type failed_ignored: int

        :param timed_out_ignored:
            The value to assign to the timed_out_ignored property of this DrPlanExecutionSkippedStepStatusCounts.
        :type timed_out_ignored: int

        :param canceled:
            The value to assign to the canceled property of this DrPlanExecutionSkippedStepStatusCounts.
        :type canceled: int

        """
        self.swagger_types = {
            'total_skipped': 'int',
            'disabled': 'int',
            'failed_ignored': 'int',
            'timed_out_ignored': 'int',
            'canceled': 'int'
        }
        self.attribute_map = {
            'total_skipped': 'totalSkipped',
            'disabled': 'disabled',
            'failed_ignored': 'failedIgnored',
            'timed_out_ignored': 'timedOutIgnored',
            'canceled': 'canceled'
        }
        self._total_skipped = None
        self._disabled = None
        self._failed_ignored = None
        self._timed_out_ignored = None
        self._canceled = None

    @property
    def total_skipped(self):
        """
        **[Required]** Gets the total_skipped of this DrPlanExecutionSkippedStepStatusCounts.
        The total number of steps that were skipped during a DR plan execution.


        :return: The total_skipped of this DrPlanExecutionSkippedStepStatusCounts.
        :rtype: int
        """
        return self._total_skipped

    @total_skipped.setter
    def total_skipped(self, total_skipped):
        """
        Sets the total_skipped of this DrPlanExecutionSkippedStepStatusCounts.
        The total number of steps that were skipped during a DR plan execution.


        :param total_skipped: The total_skipped of this DrPlanExecutionSkippedStepStatusCounts.
        :type: int
        """
        self._total_skipped = total_skipped

    @property
    def disabled(self):
        """
        **[Required]** Gets the disabled of this DrPlanExecutionSkippedStepStatusCounts.
        The total number of disabled steps in a DR plan execution.


        :return: The disabled of this DrPlanExecutionSkippedStepStatusCounts.
        :rtype: int
        """
        return self._disabled

    @disabled.setter
    def disabled(self, disabled):
        """
        Sets the disabled of this DrPlanExecutionSkippedStepStatusCounts.
        The total number of disabled steps in a DR plan execution.


        :param disabled: The disabled of this DrPlanExecutionSkippedStepStatusCounts.
        :type: int
        """
        self._disabled = disabled

    @property
    def failed_ignored(self):
        """
        **[Required]** Gets the failed_ignored of this DrPlanExecutionSkippedStepStatusCounts.
        The total number of steps that failed but were ignored during a DR plan execution.


        :return: The failed_ignored of this DrPlanExecutionSkippedStepStatusCounts.
        :rtype: int
        """
        return self._failed_ignored

    @failed_ignored.setter
    def failed_ignored(self, failed_ignored):
        """
        Sets the failed_ignored of this DrPlanExecutionSkippedStepStatusCounts.
        The total number of steps that failed but were ignored during a DR plan execution.


        :param failed_ignored: The failed_ignored of this DrPlanExecutionSkippedStepStatusCounts.
        :type: int
        """
        self._failed_ignored = failed_ignored

    @property
    def timed_out_ignored(self):
        """
        **[Required]** Gets the timed_out_ignored of this DrPlanExecutionSkippedStepStatusCounts.
        The total number of steps that timed out but were ignored during a DR plan execution.


        :return: The timed_out_ignored of this DrPlanExecutionSkippedStepStatusCounts.
        :rtype: int
        """
        return self._timed_out_ignored

    @timed_out_ignored.setter
    def timed_out_ignored(self, timed_out_ignored):
        """
        Sets the timed_out_ignored of this DrPlanExecutionSkippedStepStatusCounts.
        The total number of steps that timed out but were ignored during a DR plan execution.


        :param timed_out_ignored: The timed_out_ignored of this DrPlanExecutionSkippedStepStatusCounts.
        :type: int
        """
        self._timed_out_ignored = timed_out_ignored

    @property
    def canceled(self):
        """
        **[Required]** Gets the canceled of this DrPlanExecutionSkippedStepStatusCounts.
        The total number of canceled steps in a DR plan execution.


        :return: The canceled of this DrPlanExecutionSkippedStepStatusCounts.
        :rtype: int
        """
        return self._canceled

    @canceled.setter
    def canceled(self, canceled):
        """
        Sets the canceled of this DrPlanExecutionSkippedStepStatusCounts.
        The total number of canceled steps in a DR plan execution.


        :param canceled: The canceled of this DrPlanExecutionSkippedStepStatusCounts.
        :type: int
        """
        self._canceled = canceled

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
