# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateCatalogPeerWithDedicatedInfraDetails(object):
    """
    Details required for creation of autonomous dedicated infrastructure based catalog peer.
    """

    #: A constant which can be used with the protection_mode property of a CreateCatalogPeerWithDedicatedInfraDetails.
    #: This constant has a value of "MAXIMUM_AVAILABILITY"
    PROTECTION_MODE_MAXIMUM_AVAILABILITY = "MAXIMUM_AVAILABILITY"

    #: A constant which can be used with the protection_mode property of a CreateCatalogPeerWithDedicatedInfraDetails.
    #: This constant has a value of "MAXIMUM_PERFORMANCE"
    PROTECTION_MODE_MAXIMUM_PERFORMANCE = "MAXIMUM_PERFORMANCE"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateCatalogPeerWithDedicatedInfraDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param cloud_autonomous_vm_cluster_id:
            The value to assign to the cloud_autonomous_vm_cluster_id property of this CreateCatalogPeerWithDedicatedInfraDetails.
        :type cloud_autonomous_vm_cluster_id: str

        :param protection_mode:
            The value to assign to the protection_mode property of this CreateCatalogPeerWithDedicatedInfraDetails.
            Allowed values for this property are: "MAXIMUM_AVAILABILITY", "MAXIMUM_PERFORMANCE"
        :type protection_mode: str

        :param fast_start_fail_over_lag_limit_in_seconds:
            The value to assign to the fast_start_fail_over_lag_limit_in_seconds property of this CreateCatalogPeerWithDedicatedInfraDetails.
        :type fast_start_fail_over_lag_limit_in_seconds: int

        :param is_automatic_failover_enabled:
            The value to assign to the is_automatic_failover_enabled property of this CreateCatalogPeerWithDedicatedInfraDetails.
        :type is_automatic_failover_enabled: bool

        :param standby_maintenance_buffer_in_days:
            The value to assign to the standby_maintenance_buffer_in_days property of this CreateCatalogPeerWithDedicatedInfraDetails.
        :type standby_maintenance_buffer_in_days: int

        """
        self.swagger_types = {
            'cloud_autonomous_vm_cluster_id': 'str',
            'protection_mode': 'str',
            'fast_start_fail_over_lag_limit_in_seconds': 'int',
            'is_automatic_failover_enabled': 'bool',
            'standby_maintenance_buffer_in_days': 'int'
        }
        self.attribute_map = {
            'cloud_autonomous_vm_cluster_id': 'cloudAutonomousVmClusterId',
            'protection_mode': 'protectionMode',
            'fast_start_fail_over_lag_limit_in_seconds': 'fastStartFailOverLagLimitInSeconds',
            'is_automatic_failover_enabled': 'isAutomaticFailoverEnabled',
            'standby_maintenance_buffer_in_days': 'standbyMaintenanceBufferInDays'
        }
        self._cloud_autonomous_vm_cluster_id = None
        self._protection_mode = None
        self._fast_start_fail_over_lag_limit_in_seconds = None
        self._is_automatic_failover_enabled = None
        self._standby_maintenance_buffer_in_days = None

    @property
    def cloud_autonomous_vm_cluster_id(self):
        """
        **[Required]** Gets the cloud_autonomous_vm_cluster_id of this CreateCatalogPeerWithDedicatedInfraDetails.
        The `OCID`__ of the cloud Autonomous VM Cluster for the peer catalog.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The cloud_autonomous_vm_cluster_id of this CreateCatalogPeerWithDedicatedInfraDetails.
        :rtype: str
        """
        return self._cloud_autonomous_vm_cluster_id

    @cloud_autonomous_vm_cluster_id.setter
    def cloud_autonomous_vm_cluster_id(self, cloud_autonomous_vm_cluster_id):
        """
        Sets the cloud_autonomous_vm_cluster_id of this CreateCatalogPeerWithDedicatedInfraDetails.
        The `OCID`__ of the cloud Autonomous VM Cluster for the peer catalog.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param cloud_autonomous_vm_cluster_id: The cloud_autonomous_vm_cluster_id of this CreateCatalogPeerWithDedicatedInfraDetails.
        :type: str
        """
        self._cloud_autonomous_vm_cluster_id = cloud_autonomous_vm_cluster_id

    @property
    def protection_mode(self):
        """
        Gets the protection_mode of this CreateCatalogPeerWithDedicatedInfraDetails.
        The protectionMode for the catalog peer.

        Allowed values for this property are: "MAXIMUM_AVAILABILITY", "MAXIMUM_PERFORMANCE"


        :return: The protection_mode of this CreateCatalogPeerWithDedicatedInfraDetails.
        :rtype: str
        """
        return self._protection_mode

    @protection_mode.setter
    def protection_mode(self, protection_mode):
        """
        Sets the protection_mode of this CreateCatalogPeerWithDedicatedInfraDetails.
        The protectionMode for the catalog peer.


        :param protection_mode: The protection_mode of this CreateCatalogPeerWithDedicatedInfraDetails.
        :type: str
        """
        allowed_values = ["MAXIMUM_AVAILABILITY", "MAXIMUM_PERFORMANCE"]
        if not value_allowed_none_or_none_sentinel(protection_mode, allowed_values):
            raise ValueError(
                f"Invalid value for `protection_mode`, must be None or one of {allowed_values}"
            )
        self._protection_mode = protection_mode

    @property
    def fast_start_fail_over_lag_limit_in_seconds(self):
        """
        Gets the fast_start_fail_over_lag_limit_in_seconds of this CreateCatalogPeerWithDedicatedInfraDetails.
        The lag time preference based on data loss tolerance in seconds.


        :return: The fast_start_fail_over_lag_limit_in_seconds of this CreateCatalogPeerWithDedicatedInfraDetails.
        :rtype: int
        """
        return self._fast_start_fail_over_lag_limit_in_seconds

    @fast_start_fail_over_lag_limit_in_seconds.setter
    def fast_start_fail_over_lag_limit_in_seconds(self, fast_start_fail_over_lag_limit_in_seconds):
        """
        Sets the fast_start_fail_over_lag_limit_in_seconds of this CreateCatalogPeerWithDedicatedInfraDetails.
        The lag time preference based on data loss tolerance in seconds.


        :param fast_start_fail_over_lag_limit_in_seconds: The fast_start_fail_over_lag_limit_in_seconds of this CreateCatalogPeerWithDedicatedInfraDetails.
        :type: int
        """
        self._fast_start_fail_over_lag_limit_in_seconds = fast_start_fail_over_lag_limit_in_seconds

    @property
    def is_automatic_failover_enabled(self):
        """
        Gets the is_automatic_failover_enabled of this CreateCatalogPeerWithDedicatedInfraDetails.
        Indicates whether Automatic Failover is enabled for Autonomous Container Database Dataguard Association


        :return: The is_automatic_failover_enabled of this CreateCatalogPeerWithDedicatedInfraDetails.
        :rtype: bool
        """
        return self._is_automatic_failover_enabled

    @is_automatic_failover_enabled.setter
    def is_automatic_failover_enabled(self, is_automatic_failover_enabled):
        """
        Sets the is_automatic_failover_enabled of this CreateCatalogPeerWithDedicatedInfraDetails.
        Indicates whether Automatic Failover is enabled for Autonomous Container Database Dataguard Association


        :param is_automatic_failover_enabled: The is_automatic_failover_enabled of this CreateCatalogPeerWithDedicatedInfraDetails.
        :type: bool
        """
        self._is_automatic_failover_enabled = is_automatic_failover_enabled

    @property
    def standby_maintenance_buffer_in_days(self):
        """
        Gets the standby_maintenance_buffer_in_days of this CreateCatalogPeerWithDedicatedInfraDetails.
        The scheduling detail for the quarterly maintenance window of the standby Autonomous Container Database.
        This value represents the number of days before schedlued maintenance of the primary database.


        :return: The standby_maintenance_buffer_in_days of this CreateCatalogPeerWithDedicatedInfraDetails.
        :rtype: int
        """
        return self._standby_maintenance_buffer_in_days

    @standby_maintenance_buffer_in_days.setter
    def standby_maintenance_buffer_in_days(self, standby_maintenance_buffer_in_days):
        """
        Sets the standby_maintenance_buffer_in_days of this CreateCatalogPeerWithDedicatedInfraDetails.
        The scheduling detail for the quarterly maintenance window of the standby Autonomous Container Database.
        This value represents the number of days before schedlued maintenance of the primary database.


        :param standby_maintenance_buffer_in_days: The standby_maintenance_buffer_in_days of this CreateCatalogPeerWithDedicatedInfraDetails.
        :type: int
        """
        self._standby_maintenance_buffer_in_days = standby_maintenance_buffer_in_days

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
