# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from .base_variable import BaseVariable
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ArrayVariable(BaseVariable):
    """
    Array variable.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ArrayVariable object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.ArrayVariable.type` attribute
        of this class is ``ARRAY`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this ArrayVariable.
            Allowed values for this property are: "ARRAY", "BOOLEAN", "ENUM", "INTEGER", "NUMBER", "STRING", "TEXT", "FILE", "PASSWORD", "DATETIME", "DUMMY", "OCI_IDENTITY_DOMAINS_ID", "OCI_CORE_IMAGE_ID", "OCI_CORE_INSTANCESHAPEWITHFLEX_NAME", "OCI_CORE_INSTANCESHAPE_NAME", "OCI_CORE_NATGATEWAY_ID", "OCI_CORE_INSTANCE_ID", "OCI_CORE_SUBNET_ID", "OCI_CORE_SERVICEGATEWAY_ID", "OCI_LOGAN_LOGGROUP_ID", "OCI_LOGAN_SCHEDULEDTASK_ID", "OCI_LOGAN_LOGENTITY_ID", "OCI_LOGAN_ENTITYTYPE_ID", "OCI_MGMT_AGENT_ID", "OCI_LOGAN_SOURCE_ID", "OCI_CORE_NSG_ID", "OCI_CORE_VCN_ID", "OCI_IDENTITY_AVAILABILITYDOMAIN_NAME", "OCI_IDENTITY_COMPARTMENT_ID", "OCI_IDENTITY_FAULTDOMAIN_NAME", "OCI_IDENTITY_REGION_NAME", "OCI_DATABASE_DBSYSTEM_ID", "OCI_DATABASE_DBHOME_ID", "OCI_DATABASE_DBHOME_DBVERSION", "OCI_DATABASE_DATABASE_ID", "OCI_DATABASE_AUTONOMOUSDATABASE_ID", "OCI_DATABASE_AUTONOMOUSDATABASEVERSION_ID", "OCI_DATABASE_AUTONOMOUSCONTAINERDATABASE_ID", "OCI_KMS_KEY_ID", "OCI_KMS_SECRET_ID", "OCI_CONTAINER_CLUSTER_ID", "OCI_KUBERNETES_VERSIONS_ID", "OCI_BLOCKSTORAGE_POLICIES_ID", "OCI_IDENTITY_GROUPS_ID", "OCI_IDENTITY_DYNAMICGROUPS_ID", "OCI_LOADBALANCER_LOADBALANCER_ID", "OCI_MOUNT_TARGET_ID", "OCI_IDENTITY_TAG_VALUE", "OCI_ODS_PROJECT_ID", "OCI_RESOURCEMANAGER_PRIVATEENDPOINT_ID", "OCI_APM_DOMAIN_ID", "OCI_CORE_SSH_PUBLICKEY", "OCI_KMS_VAULT_ID", "OCI_LOADBALANCER_NETWORKLOADBALANCER_ID", "OCI_LOADBALANCER_LOADBALANCER_RESERVEDIPS_ID", "OCI_DATABASE_MYSQL_SHAPE_ID", "OCI_DATABASE_MYSQL_CONFIGURATION_ID", "OCI_STORAGE_FILESTORAGE_EXPORTSET_ID", "OCI_STORAGE_FILESTORAGE_FILESYSTEM_ID", "OCI_STORAGE_OBJECTSTORAGE_BUCKET_NAME", "OCI_CORE_VCN_SECLIST_ID", "OCI_CORE_VOLUME_ID", "OCI_DATABASE_DATAGUARD_ID", "OCI_DATABASE_EXADATA_ID", "OCI_DATABASE_CLOUDVMCLUSTER_ID", "OCI_DATABASE_CDB_ID", "OCI_DATABASE_DATAGUARDASSOCIATION_ID", "OCI_DATABASE_DBNODE_ID", "OCI_CORE_VCN_NETWORKSECURITYGROUP_ID", "OCI_STORAGE_FILESTORAGE_MOUNTTARGET_ID"
        :type type: str

        :param title:
            The value to assign to the title property of this ArrayVariable.
        :type title: str

        :param description:
            The value to assign to the description property of this ArrayVariable.
        :type description: str

        :param is_required:
            The value to assign to the is_required property of this ArrayVariable.
        :type is_required: bool

        :param visible:
            The value to assign to the visible property of this ArrayVariable.
        :type visible: str

        :param items:
            The value to assign to the items property of this ArrayVariable.
        :type items: oci.fleet_apps_management.models.BaseVariable

        :param max_items:
            The value to assign to the max_items property of this ArrayVariable.
        :type max_items: int

        :param min_items:
            The value to assign to the min_items property of this ArrayVariable.
        :type min_items: int

        :param are_unique_items:
            The value to assign to the are_unique_items property of this ArrayVariable.
        :type are_unique_items: bool

        :param default_value:
            The value to assign to the default_value property of this ArrayVariable.
        :type default_value: object

        :param contains:
            The value to assign to the contains property of this ArrayVariable.
        :type contains: oci.fleet_apps_management.models.BaseVariable

        """
        self.swagger_types = {
            'type': 'str',
            'title': 'str',
            'description': 'str',
            'is_required': 'bool',
            'visible': 'str',
            'items': 'BaseVariable',
            'max_items': 'int',
            'min_items': 'int',
            'are_unique_items': 'bool',
            'default_value': 'object',
            'contains': 'BaseVariable'
        }
        self.attribute_map = {
            'type': 'type',
            'title': 'title',
            'description': 'description',
            'is_required': 'isRequired',
            'visible': 'visible',
            'items': 'items',
            'max_items': 'maxItems',
            'min_items': 'minItems',
            'are_unique_items': 'areUniqueItems',
            'default_value': 'defaultValue',
            'contains': 'contains'
        }
        self._type = None
        self._title = None
        self._description = None
        self._is_required = None
        self._visible = None
        self._items = None
        self._max_items = None
        self._min_items = None
        self._are_unique_items = None
        self._default_value = None
        self._contains = None
        self._type = 'ARRAY'

    @property
    def items(self):
        """
        Gets the items of this ArrayVariable.

        :return: The items of this ArrayVariable.
        :rtype: oci.fleet_apps_management.models.BaseVariable
        """
        return self._items

    @items.setter
    def items(self, items):
        """
        Sets the items of this ArrayVariable.

        :param items: The items of this ArrayVariable.
        :type: oci.fleet_apps_management.models.BaseVariable
        """
        self._items = items

    @property
    def max_items(self):
        """
        Gets the max_items of this ArrayVariable.
        Maximum allowed items in the array.


        :return: The max_items of this ArrayVariable.
        :rtype: int
        """
        return self._max_items

    @max_items.setter
    def max_items(self, max_items):
        """
        Sets the max_items of this ArrayVariable.
        Maximum allowed items in the array.


        :param max_items: The max_items of this ArrayVariable.
        :type: int
        """
        self._max_items = max_items

    @property
    def min_items(self):
        """
        Gets the min_items of this ArrayVariable.
        Minimum allowed items in the array.


        :return: The min_items of this ArrayVariable.
        :rtype: int
        """
        return self._min_items

    @min_items.setter
    def min_items(self, min_items):
        """
        Sets the min_items of this ArrayVariable.
        Minimum allowed items in the array.


        :param min_items: The min_items of this ArrayVariable.
        :type: int
        """
        self._min_items = min_items

    @property
    def are_unique_items(self):
        """
        Gets the are_unique_items of this ArrayVariable.
        If true, array entries will be unique.


        :return: The are_unique_items of this ArrayVariable.
        :rtype: bool
        """
        return self._are_unique_items

    @are_unique_items.setter
    def are_unique_items(self, are_unique_items):
        """
        Sets the are_unique_items of this ArrayVariable.
        If true, array entries will be unique.


        :param are_unique_items: The are_unique_items of this ArrayVariable.
        :type: bool
        """
        self._are_unique_items = are_unique_items

    @property
    def default_value(self):
        """
        Gets the default_value of this ArrayVariable.
        The default value for this variable.


        :return: The default_value of this ArrayVariable.
        :rtype: object
        """
        return self._default_value

    @default_value.setter
    def default_value(self, default_value):
        """
        Sets the default_value of this ArrayVariable.
        The default value for this variable.


        :param default_value: The default_value of this ArrayVariable.
        :type: object
        """
        self._default_value = default_value

    @property
    def contains(self):
        """
        Gets the contains of this ArrayVariable.

        :return: The contains of this ArrayVariable.
        :rtype: oci.fleet_apps_management.models.BaseVariable
        """
        return self._contains

    @contains.setter
    def contains(self, contains):
        """
        Sets the contains of this ArrayVariable.

        :param contains: The contains of this ArrayVariable.
        :type: oci.fleet_apps_management.models.BaseVariable
        """
        self._contains = contains

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
