# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from .task_argument import TaskArgument
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FileTaskArgument(TaskArgument):
    """
    A file variable that holds a value
    """

    def __init__(self, **kwargs):
        """
        Initializes a new FileTaskArgument object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.FileTaskArgument.kind` attribute
        of this class is ``FILE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param kind:
            The value to assign to the kind property of this FileTaskArgument.
            Allowed values for this property are: "STRING", "FILE"
        :type kind: str

        :param name:
            The value to assign to the name property of this FileTaskArgument.
        :type name: str

        :param content:
            The value to assign to the content property of this FileTaskArgument.
        :type content: oci.fleet_apps_management.models.InputFileContentDetails

        """
        self.swagger_types = {
            'kind': 'str',
            'name': 'str',
            'content': 'InputFileContentDetails'
        }
        self.attribute_map = {
            'kind': 'kind',
            'name': 'name',
            'content': 'content'
        }
        self._kind = None
        self._name = None
        self._content = None
        self._kind = 'FILE'

    @property
    def content(self):
        """
        Gets the content of this FileTaskArgument.

        :return: The content of this FileTaskArgument.
        :rtype: oci.fleet_apps_management.models.InputFileContentDetails
        """
        return self._content

    @content.setter
    def content(self, content):
        """
        Sets the content of this FileTaskArgument.

        :param content: The content of this FileTaskArgument.
        :type: oci.fleet_apps_management.models.InputFileContentDetails
        """
        self._content = content

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
