# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PatchSelectionDetails(object):
    """
    Patch Selection Details
    """

    #: A constant which can be used with the selection_type property of a PatchSelectionDetails.
    #: This constant has a value of "PATCH_LEVEL"
    SELECTION_TYPE_PATCH_LEVEL = "PATCH_LEVEL"

    #: A constant which can be used with the selection_type property of a PatchSelectionDetails.
    #: This constant has a value of "PATCH_NAME"
    SELECTION_TYPE_PATCH_NAME = "PATCH_NAME"

    #: A constant which can be used with the selection_type property of a PatchSelectionDetails.
    #: This constant has a value of "PATCH_RELEASE_DATE"
    SELECTION_TYPE_PATCH_RELEASE_DATE = "PATCH_RELEASE_DATE"

    def __init__(self, **kwargs):
        """
        Initializes a new PatchSelectionDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.fleet_apps_management.models.PatchLevelSelectionDetails`
        * :class:`~oci.fleet_apps_management.models.PatchReleaseDateSelectionDetails`
        * :class:`~oci.fleet_apps_management.models.PatchNameSelectionDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param selection_type:
            The value to assign to the selection_type property of this PatchSelectionDetails.
            Allowed values for this property are: "PATCH_LEVEL", "PATCH_NAME", "PATCH_RELEASE_DATE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type selection_type: str

        """
        self.swagger_types = {
            'selection_type': 'str'
        }
        self.attribute_map = {
            'selection_type': 'selectionType'
        }
        self._selection_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['selectionType']

        if type == 'PATCH_LEVEL':
            return 'PatchLevelSelectionDetails'

        if type == 'PATCH_RELEASE_DATE':
            return 'PatchReleaseDateSelectionDetails'

        if type == 'PATCH_NAME':
            return 'PatchNameSelectionDetails'
        else:
            return 'PatchSelectionDetails'

    @property
    def selection_type(self):
        """
        **[Required]** Gets the selection_type of this PatchSelectionDetails.
        Selection type for the Patch.

        Allowed values for this property are: "PATCH_LEVEL", "PATCH_NAME", "PATCH_RELEASE_DATE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The selection_type of this PatchSelectionDetails.
        :rtype: str
        """
        return self._selection_type

    @selection_type.setter
    def selection_type(self, selection_type):
        """
        Sets the selection_type of this PatchSelectionDetails.
        Selection type for the Patch.


        :param selection_type: The selection_type of this PatchSelectionDetails.
        :type: str
        """
        allowed_values = ["PATCH_LEVEL", "PATCH_NAME", "PATCH_RELEASE_DATE"]
        if not value_allowed_none_or_none_sentinel(selection_type, allowed_values):
            selection_type = 'UNKNOWN_ENUM_VALUE'
        self._selection_type = selection_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
