# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RequiredValue(object):
    """
    Required value.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RequiredValue object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param field:
            The value to assign to the field property of this RequiredValue.
        :type field: str

        """
        self.swagger_types = {
            'field': 'str'
        }
        self.attribute_map = {
            'field': 'field'
        }
        self._field = None

    @property
    def field(self):
        """
        **[Required]** Gets the field of this RequiredValue.
        Field for required value.


        :return: The field of this RequiredValue.
        :rtype: str
        """
        return self._field

    @field.setter
    def field(self, field):
        """
        Sets the field of this RequiredValue.
        Field for required value.


        :param field: The field of this RequiredValue.
        :type: str
        """
        self._field = field

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
