# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RunbookExportStatusSummary(object):
    """
    Summary of the Runbook export status.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RunbookExportStatusSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param tracking_id:
            The value to assign to the tracking_id property of this RunbookExportStatusSummary.
        :type tracking_id: str

        :param runbook_id:
            The value to assign to the runbook_id property of this RunbookExportStatusSummary.
        :type runbook_id: str

        :param runbook_name:
            The value to assign to the runbook_name property of this RunbookExportStatusSummary.
        :type runbook_name: str

        :param runbook_version:
            The value to assign to the runbook_version property of this RunbookExportStatusSummary.
        :type runbook_version: str

        :param status:
            The value to assign to the status property of this RunbookExportStatusSummary.
        :type status: str

        """
        self.swagger_types = {
            'tracking_id': 'str',
            'runbook_id': 'str',
            'runbook_name': 'str',
            'runbook_version': 'str',
            'status': 'str'
        }
        self.attribute_map = {
            'tracking_id': 'trackingId',
            'runbook_id': 'runbookId',
            'runbook_name': 'runbookName',
            'runbook_version': 'runbookVersion',
            'status': 'status'
        }
        self._tracking_id = None
        self._runbook_id = None
        self._runbook_name = None
        self._runbook_version = None
        self._status = None

    @property
    def tracking_id(self):
        """
        **[Required]** Gets the tracking_id of this RunbookExportStatusSummary.
        Tracking Id.


        :return: The tracking_id of this RunbookExportStatusSummary.
        :rtype: str
        """
        return self._tracking_id

    @tracking_id.setter
    def tracking_id(self, tracking_id):
        """
        Sets the tracking_id of this RunbookExportStatusSummary.
        Tracking Id.


        :param tracking_id: The tracking_id of this RunbookExportStatusSummary.
        :type: str
        """
        self._tracking_id = tracking_id

    @property
    def runbook_id(self):
        """
        **[Required]** Gets the runbook_id of this RunbookExportStatusSummary.
        The OCID of the resource.


        :return: The runbook_id of this RunbookExportStatusSummary.
        :rtype: str
        """
        return self._runbook_id

    @runbook_id.setter
    def runbook_id(self, runbook_id):
        """
        Sets the runbook_id of this RunbookExportStatusSummary.
        The OCID of the resource.


        :param runbook_id: The runbook_id of this RunbookExportStatusSummary.
        :type: str
        """
        self._runbook_id = runbook_id

    @property
    def runbook_name(self):
        """
        **[Required]** Gets the runbook_name of this RunbookExportStatusSummary.
        Runbook name.


        :return: The runbook_name of this RunbookExportStatusSummary.
        :rtype: str
        """
        return self._runbook_name

    @runbook_name.setter
    def runbook_name(self, runbook_name):
        """
        Sets the runbook_name of this RunbookExportStatusSummary.
        Runbook name.


        :param runbook_name: The runbook_name of this RunbookExportStatusSummary.
        :type: str
        """
        self._runbook_name = runbook_name

    @property
    def runbook_version(self):
        """
        **[Required]** Gets the runbook_version of this RunbookExportStatusSummary.
        Runbook version.


        :return: The runbook_version of this RunbookExportStatusSummary.
        :rtype: str
        """
        return self._runbook_version

    @runbook_version.setter
    def runbook_version(self, runbook_version):
        """
        Sets the runbook_version of this RunbookExportStatusSummary.
        Runbook version.


        :param runbook_version: The runbook_version of this RunbookExportStatusSummary.
        :type: str
        """
        self._runbook_version = runbook_version

    @property
    def status(self):
        """
        **[Required]** Gets the status of this RunbookExportStatusSummary.
        Status.


        :return: The status of this RunbookExportStatusSummary.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this RunbookExportStatusSummary.
        Status.


        :param status: The status of this RunbookExportStatusSummary.
        :type: str
        """
        self._status = status

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
