# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RunbookImportAs(object):
    """
    Runbook import as type.
    """

    #: A constant which can be used with the import_type property of a RunbookImportAs.
    #: This constant has a value of "RUNBOOK"
    IMPORT_TYPE_RUNBOOK = "RUNBOOK"

    #: A constant which can be used with the import_type property of a RunbookImportAs.
    #: This constant has a value of "RUNBOOK_VERSION"
    IMPORT_TYPE_RUNBOOK_VERSION = "RUNBOOK_VERSION"

    def __init__(self, **kwargs):
        """
        Initializes a new RunbookImportAs object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.fleet_apps_management.models.RunbookImportAsVersion`
        * :class:`~oci.fleet_apps_management.models.RunbookImportAsRunbook`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param import_type:
            The value to assign to the import_type property of this RunbookImportAs.
            Allowed values for this property are: "RUNBOOK", "RUNBOOK_VERSION"
        :type import_type: str

        :param version:
            The value to assign to the version property of this RunbookImportAs.
        :type version: str

        :param import_option:
            The value to assign to the import_option property of this RunbookImportAs.
        :type import_option: str

        """
        self.swagger_types = {
            'import_type': 'str',
            'version': 'str',
            'import_option': 'str'
        }
        self.attribute_map = {
            'import_type': 'importType',
            'version': 'version',
            'import_option': 'importOption'
        }
        self._import_type = None
        self._version = None
        self._import_option = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['importType']

        if type == 'RUNBOOK_VERSION':
            return 'RunbookImportAsVersion'

        if type == 'RUNBOOK':
            return 'RunbookImportAsRunbook'
        else:
            return 'RunbookImportAs'

    @property
    def import_type(self):
        """
        **[Required]** Gets the import_type of this RunbookImportAs.
        Import type.

        Allowed values for this property are: "RUNBOOK", "RUNBOOK_VERSION"


        :return: The import_type of this RunbookImportAs.
        :rtype: str
        """
        return self._import_type

    @import_type.setter
    def import_type(self, import_type):
        """
        Sets the import_type of this RunbookImportAs.
        Import type.


        :param import_type: The import_type of this RunbookImportAs.
        :type: str
        """
        allowed_values = ["RUNBOOK", "RUNBOOK_VERSION"]
        if not value_allowed_none_or_none_sentinel(import_type, allowed_values):
            raise ValueError(
                f"Invalid value for `import_type`, must be None or one of {allowed_values}"
            )
        self._import_type = import_type

    @property
    def version(self):
        """
        Gets the version of this RunbookImportAs.
        Version number.


        :return: The version of this RunbookImportAs.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this RunbookImportAs.
        Version number.


        :param version: The version of this RunbookImportAs.
        :type: str
        """
        self._version = version

    @property
    def import_option(self):
        """
        **[Required]** Gets the import_option of this RunbookImportAs.
        ImportOptions for Runbook.


        :return: The import_option of this RunbookImportAs.
        :rtype: str
        """
        return self._import_option

    @import_option.setter
    def import_option(self, import_option):
        """
        Sets the import_option of this RunbookImportAs.
        ImportOptions for Runbook.


        :param import_option: The import_option of this RunbookImportAs.
        :type: str
        """
        self._import_option = import_option

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
