# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RunbookSummary(object):
    """
    Summary of the Runbook.
    """

    #: A constant which can be used with the os_type property of a RunbookSummary.
    #: This constant has a value of "WINDOWS"
    OS_TYPE_WINDOWS = "WINDOWS"

    #: A constant which can be used with the os_type property of a RunbookSummary.
    #: This constant has a value of "LINUX"
    OS_TYPE_LINUX = "LINUX"

    #: A constant which can be used with the os_type property of a RunbookSummary.
    #: This constant has a value of "GENERIC"
    OS_TYPE_GENERIC = "GENERIC"

    def __init__(self, **kwargs):
        """
        Initializes a new RunbookSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this RunbookSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this RunbookSummary.
        :type display_name: str

        :param description:
            The value to assign to the description property of this RunbookSummary.
        :type description: str

        :param type:
            The value to assign to the type property of this RunbookSummary.
        :type type: str

        :param operation:
            The value to assign to the operation property of this RunbookSummary.
        :type operation: str

        :param os_type:
            The value to assign to the os_type property of this RunbookSummary.
            Allowed values for this property are: "WINDOWS", "LINUX", "GENERIC", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type os_type: str

        :param platform:
            The value to assign to the platform property of this RunbookSummary.
        :type platform: str

        :param is_default:
            The value to assign to the is_default property of this RunbookSummary.
        :type is_default: bool

        :param estimated_time:
            The value to assign to the estimated_time property of this RunbookSummary.
        :type estimated_time: str

        :param latest_version:
            The value to assign to the latest_version property of this RunbookSummary.
        :type latest_version: str

        :param has_draft_version:
            The value to assign to the has_draft_version property of this RunbookSummary.
        :type has_draft_version: bool

        :param original_version:
            The value to assign to the original_version property of this RunbookSummary.
        :type original_version: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this RunbookSummary.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this RunbookSummary.
        :type lifecycle_details: str

        :param time_created:
            The value to assign to the time_created property of this RunbookSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this RunbookSummary.
        :type time_updated: datetime

        :param compartment_id:
            The value to assign to the compartment_id property of this RunbookSummary.
        :type compartment_id: str

        :param resource_region:
            The value to assign to the resource_region property of this RunbookSummary.
        :type resource_region: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this RunbookSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this RunbookSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this RunbookSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'description': 'str',
            'type': 'str',
            'operation': 'str',
            'os_type': 'str',
            'platform': 'str',
            'is_default': 'bool',
            'estimated_time': 'str',
            'latest_version': 'str',
            'has_draft_version': 'bool',
            'original_version': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'compartment_id': 'str',
            'resource_region': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'description': 'description',
            'type': 'type',
            'operation': 'operation',
            'os_type': 'osType',
            'platform': 'platform',
            'is_default': 'isDefault',
            'estimated_time': 'estimatedTime',
            'latest_version': 'latestVersion',
            'has_draft_version': 'hasDraftVersion',
            'original_version': 'originalVersion',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'compartment_id': 'compartmentId',
            'resource_region': 'resourceRegion',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._description = None
        self._type = None
        self._operation = None
        self._os_type = None
        self._platform = None
        self._is_default = None
        self._estimated_time = None
        self._latest_version = None
        self._has_draft_version = None
        self._original_version = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._time_created = None
        self._time_updated = None
        self._compartment_id = None
        self._resource_region = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this RunbookSummary.
        The OCID of the resource.


        :return: The id of this RunbookSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this RunbookSummary.
        The OCID of the resource.


        :param id: The id of this RunbookSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this RunbookSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :return: The display_name of this RunbookSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this RunbookSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :param display_name: The display_name of this RunbookSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this RunbookSummary.
        A user-friendly description. To provide some insight about the resource.
        Avoid entering confidential information.


        :return: The description of this RunbookSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this RunbookSummary.
        A user-friendly description. To provide some insight about the resource.
        Avoid entering confidential information.


        :param description: The description of this RunbookSummary.
        :type: str
        """
        self._description = description

    @property
    def type(self):
        """
        **[Required]** Gets the type of this RunbookSummary.
        The type of the runbook.


        :return: The type of this RunbookSummary.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this RunbookSummary.
        The type of the runbook.


        :param type: The type of this RunbookSummary.
        :type: str
        """
        self._type = type

    @property
    def operation(self):
        """
        **[Required]** Gets the operation of this RunbookSummary.
        The lifecycle operation performed by the runbook.


        :return: The operation of this RunbookSummary.
        :rtype: str
        """
        return self._operation

    @operation.setter
    def operation(self, operation):
        """
        Sets the operation of this RunbookSummary.
        The lifecycle operation performed by the runbook.


        :param operation: The operation of this RunbookSummary.
        :type: str
        """
        self._operation = operation

    @property
    def os_type(self):
        """
        Gets the os_type of this RunbookSummary.
        The OS type for the runbook.

        Allowed values for this property are: "WINDOWS", "LINUX", "GENERIC", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The os_type of this RunbookSummary.
        :rtype: str
        """
        return self._os_type

    @os_type.setter
    def os_type(self, os_type):
        """
        Sets the os_type of this RunbookSummary.
        The OS type for the runbook.


        :param os_type: The os_type of this RunbookSummary.
        :type: str
        """
        allowed_values = ["WINDOWS", "LINUX", "GENERIC"]
        if not value_allowed_none_or_none_sentinel(os_type, allowed_values):
            os_type = 'UNKNOWN_ENUM_VALUE'
        self._os_type = os_type

    @property
    def platform(self):
        """
        Gets the platform of this RunbookSummary.
        The platform of the runbook.


        :return: The platform of this RunbookSummary.
        :rtype: str
        """
        return self._platform

    @platform.setter
    def platform(self, platform):
        """
        Sets the platform of this RunbookSummary.
        The platform of the runbook.


        :param platform: The platform of this RunbookSummary.
        :type: str
        """
        self._platform = platform

    @property
    def is_default(self):
        """
        **[Required]** Gets the is_default of this RunbookSummary.
        Is the runbook default?
        Sets this runbook as the default for the chosen product/product stack for the specified lifecycle operation.


        :return: The is_default of this RunbookSummary.
        :rtype: bool
        """
        return self._is_default

    @is_default.setter
    def is_default(self, is_default):
        """
        Sets the is_default of this RunbookSummary.
        Is the runbook default?
        Sets this runbook as the default for the chosen product/product stack for the specified lifecycle operation.


        :param is_default: The is_default of this RunbookSummary.
        :type: bool
        """
        self._is_default = is_default

    @property
    def estimated_time(self):
        """
        Gets the estimated_time of this RunbookSummary.
        Estimated time to successfully complete the runbook execution.


        :return: The estimated_time of this RunbookSummary.
        :rtype: str
        """
        return self._estimated_time

    @estimated_time.setter
    def estimated_time(self, estimated_time):
        """
        Sets the estimated_time of this RunbookSummary.
        Estimated time to successfully complete the runbook execution.


        :param estimated_time: The estimated_time of this RunbookSummary.
        :type: str
        """
        self._estimated_time = estimated_time

    @property
    def latest_version(self):
        """
        Gets the latest_version of this RunbookSummary.
        Latest runbook version


        :return: The latest_version of this RunbookSummary.
        :rtype: str
        """
        return self._latest_version

    @latest_version.setter
    def latest_version(self, latest_version):
        """
        Sets the latest_version of this RunbookSummary.
        Latest runbook version


        :param latest_version: The latest_version of this RunbookSummary.
        :type: str
        """
        self._latest_version = latest_version

    @property
    def has_draft_version(self):
        """
        Gets the has_draft_version of this RunbookSummary.
        Does this runbook has draft versions?


        :return: The has_draft_version of this RunbookSummary.
        :rtype: bool
        """
        return self._has_draft_version

    @has_draft_version.setter
    def has_draft_version(self, has_draft_version):
        """
        Sets the has_draft_version of this RunbookSummary.
        Does this runbook has draft versions?


        :param has_draft_version: The has_draft_version of this RunbookSummary.
        :type: bool
        """
        self._has_draft_version = has_draft_version

    @property
    def original_version(self):
        """
        Gets the original_version of this RunbookSummary.
        Original runbook version. This version belongs to original runbook using which new runbook was exported.


        :return: The original_version of this RunbookSummary.
        :rtype: str
        """
        return self._original_version

    @original_version.setter
    def original_version(self, original_version):
        """
        Sets the original_version of this RunbookSummary.
        Original runbook version. This version belongs to original runbook using which new runbook was exported.


        :param original_version: The original_version of this RunbookSummary.
        :type: str
        """
        self._original_version = original_version

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this RunbookSummary.
        The current state of the Runbook.


        :return: The lifecycle_state of this RunbookSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this RunbookSummary.
        The current state of the Runbook.


        :param lifecycle_state: The lifecycle_state of this RunbookSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this RunbookSummary.
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.


        :return: The lifecycle_details of this RunbookSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this RunbookSummary.
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.


        :param lifecycle_details: The lifecycle_details of this RunbookSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this RunbookSummary.
        The time this resource was created. An RFC3339 formatted datetime string.


        :return: The time_created of this RunbookSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this RunbookSummary.
        The time this resource was created. An RFC3339 formatted datetime string.


        :param time_created: The time_created of this RunbookSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this RunbookSummary.
        The time this resource was last updated. An RFC3339 formatted datetime string.


        :return: The time_updated of this RunbookSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this RunbookSummary.
        The time this resource was last updated. An RFC3339 formatted datetime string.


        :param time_updated: The time_updated of this RunbookSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this RunbookSummary.
        OCID of the compartment to which the resource belongs to.


        :return: The compartment_id of this RunbookSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this RunbookSummary.
        OCID of the compartment to which the resource belongs to.


        :param compartment_id: The compartment_id of this RunbookSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def resource_region(self):
        """
        Gets the resource_region of this RunbookSummary.
        Associated region


        :return: The resource_region of this RunbookSummary.
        :rtype: str
        """
        return self._resource_region

    @resource_region.setter
    def resource_region(self, resource_region):
        """
        Sets the resource_region of this RunbookSummary.
        Associated region


        :param resource_region: The resource_region of this RunbookSummary.
        :type: str
        """
        self._resource_region = resource_region

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this RunbookSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this RunbookSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this RunbookSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this RunbookSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this RunbookSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this RunbookSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this RunbookSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this RunbookSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this RunbookSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this RunbookSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this RunbookSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this RunbookSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
