# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RunbookVersion(object):
    """
    Version for the runbook.
    Versioning runbooks in Fleet Application Management involve assigning unique identifiers or version numbers to different iterations of the runbook to track changes, improvements, and updates over time.
    """

    #: A constant which can be used with the lifecycle_state property of a RunbookVersion.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a RunbookVersion.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a RunbookVersion.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a RunbookVersion.
    #: This constant has a value of "NEEDS_ATTENTION"
    LIFECYCLE_STATE_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    #: A constant which can be used with the lifecycle_state property of a RunbookVersion.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a RunbookVersion.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a RunbookVersion.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a RunbookVersion.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    def __init__(self, **kwargs):
        """
        Initializes a new RunbookVersion object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this RunbookVersion.
        :type id: str

        :param runbook_id:
            The value to assign to the runbook_id property of this RunbookVersion.
        :type runbook_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this RunbookVersion.
        :type compartment_id: str

        :param tasks:
            The value to assign to the tasks property of this RunbookVersion.
        :type tasks: list[oci.fleet_apps_management.models.Task]

        :param groups:
            The value to assign to the groups property of this RunbookVersion.
        :type groups: list[oci.fleet_apps_management.models.Group]

        :param execution_workflow_details:
            The value to assign to the execution_workflow_details property of this RunbookVersion.
        :type execution_workflow_details: oci.fleet_apps_management.models.ExecutionWorkflowDetails

        :param rollback_workflow_details:
            The value to assign to the rollback_workflow_details property of this RunbookVersion.
        :type rollback_workflow_details: oci.fleet_apps_management.models.RollbackWorkflowDetails

        :param name:
            The value to assign to the name property of this RunbookVersion.
        :type name: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this RunbookVersion.
            Allowed values for this property are: "ACTIVE", "DELETED", "FAILED", "NEEDS_ATTENTION", "INACTIVE", "CREATING", "DELETING", "UPDATING", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this RunbookVersion.
        :type lifecycle_details: str

        :param time_created:
            The value to assign to the time_created property of this RunbookVersion.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this RunbookVersion.
        :type time_updated: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this RunbookVersion.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this RunbookVersion.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this RunbookVersion.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'runbook_id': 'str',
            'compartment_id': 'str',
            'tasks': 'list[Task]',
            'groups': 'list[Group]',
            'execution_workflow_details': 'ExecutionWorkflowDetails',
            'rollback_workflow_details': 'RollbackWorkflowDetails',
            'name': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'runbook_id': 'runbookId',
            'compartment_id': 'compartmentId',
            'tasks': 'tasks',
            'groups': 'groups',
            'execution_workflow_details': 'executionWorkflowDetails',
            'rollback_workflow_details': 'rollbackWorkflowDetails',
            'name': 'name',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._runbook_id = None
        self._compartment_id = None
        self._tasks = None
        self._groups = None
        self._execution_workflow_details = None
        self._rollback_workflow_details = None
        self._name = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._time_created = None
        self._time_updated = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this RunbookVersion.
        The OCID of the resource.


        :return: The id of this RunbookVersion.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this RunbookVersion.
        The OCID of the resource.


        :param id: The id of this RunbookVersion.
        :type: str
        """
        self._id = id

    @property
    def runbook_id(self):
        """
        **[Required]** Gets the runbook_id of this RunbookVersion.
        The OCID of the resource.


        :return: The runbook_id of this RunbookVersion.
        :rtype: str
        """
        return self._runbook_id

    @runbook_id.setter
    def runbook_id(self, runbook_id):
        """
        Sets the runbook_id of this RunbookVersion.
        The OCID of the resource.


        :param runbook_id: The runbook_id of this RunbookVersion.
        :type: str
        """
        self._runbook_id = runbook_id

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this RunbookVersion.
        OCID of the compartment to which the resource belongs to.


        :return: The compartment_id of this RunbookVersion.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this RunbookVersion.
        OCID of the compartment to which the resource belongs to.


        :param compartment_id: The compartment_id of this RunbookVersion.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def tasks(self):
        """
        **[Required]** Gets the tasks of this RunbookVersion.
        A set of tasks to execute in the runbook.


        :return: The tasks of this RunbookVersion.
        :rtype: list[oci.fleet_apps_management.models.Task]
        """
        return self._tasks

    @tasks.setter
    def tasks(self, tasks):
        """
        Sets the tasks of this RunbookVersion.
        A set of tasks to execute in the runbook.


        :param tasks: The tasks of this RunbookVersion.
        :type: list[oci.fleet_apps_management.models.Task]
        """
        self._tasks = tasks

    @property
    def groups(self):
        """
        **[Required]** Gets the groups of this RunbookVersion.
        The groups of the runbook.


        :return: The groups of this RunbookVersion.
        :rtype: list[oci.fleet_apps_management.models.Group]
        """
        return self._groups

    @groups.setter
    def groups(self, groups):
        """
        Sets the groups of this RunbookVersion.
        The groups of the runbook.


        :param groups: The groups of this RunbookVersion.
        :type: list[oci.fleet_apps_management.models.Group]
        """
        self._groups = groups

    @property
    def execution_workflow_details(self):
        """
        **[Required]** Gets the execution_workflow_details of this RunbookVersion.

        :return: The execution_workflow_details of this RunbookVersion.
        :rtype: oci.fleet_apps_management.models.ExecutionWorkflowDetails
        """
        return self._execution_workflow_details

    @execution_workflow_details.setter
    def execution_workflow_details(self, execution_workflow_details):
        """
        Sets the execution_workflow_details of this RunbookVersion.

        :param execution_workflow_details: The execution_workflow_details of this RunbookVersion.
        :type: oci.fleet_apps_management.models.ExecutionWorkflowDetails
        """
        self._execution_workflow_details = execution_workflow_details

    @property
    def rollback_workflow_details(self):
        """
        Gets the rollback_workflow_details of this RunbookVersion.

        :return: The rollback_workflow_details of this RunbookVersion.
        :rtype: oci.fleet_apps_management.models.RollbackWorkflowDetails
        """
        return self._rollback_workflow_details

    @rollback_workflow_details.setter
    def rollback_workflow_details(self, rollback_workflow_details):
        """
        Sets the rollback_workflow_details of this RunbookVersion.

        :param rollback_workflow_details: The rollback_workflow_details of this RunbookVersion.
        :type: oci.fleet_apps_management.models.RollbackWorkflowDetails
        """
        self._rollback_workflow_details = rollback_workflow_details

    @property
    def name(self):
        """
        Gets the name of this RunbookVersion.
        The version of the runbook.


        :return: The name of this RunbookVersion.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this RunbookVersion.
        The version of the runbook.


        :param name: The name of this RunbookVersion.
        :type: str
        """
        self._name = name

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this RunbookVersion.
        The current state of the runbook version.

        Allowed values for this property are: "ACTIVE", "DELETED", "FAILED", "NEEDS_ATTENTION", "INACTIVE", "CREATING", "DELETING", "UPDATING", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this RunbookVersion.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this RunbookVersion.
        The current state of the runbook version.


        :param lifecycle_state: The lifecycle_state of this RunbookVersion.
        :type: str
        """
        allowed_values = ["ACTIVE", "DELETED", "FAILED", "NEEDS_ATTENTION", "INACTIVE", "CREATING", "DELETING", "UPDATING"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this RunbookVersion.
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.


        :return: The lifecycle_details of this RunbookVersion.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this RunbookVersion.
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.


        :param lifecycle_details: The lifecycle_details of this RunbookVersion.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def time_created(self):
        """
        Gets the time_created of this RunbookVersion.
        The time this resource was created. An RFC3339 formatted datetime string.


        :return: The time_created of this RunbookVersion.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this RunbookVersion.
        The time this resource was created. An RFC3339 formatted datetime string.


        :param time_created: The time_created of this RunbookVersion.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this RunbookVersion.
        The time this resource was last updated. An RFC3339 formatted datetime string.


        :return: The time_updated of this RunbookVersion.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this RunbookVersion.
        The time this resource was last updated. An RFC3339 formatted datetime string.


        :param time_updated: The time_updated of this RunbookVersion.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this RunbookVersion.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this RunbookVersion.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this RunbookVersion.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this RunbookVersion.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this RunbookVersion.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this RunbookVersion.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this RunbookVersion.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this RunbookVersion.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this RunbookVersion.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this RunbookVersion.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this RunbookVersion.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this RunbookVersion.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
