# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SelectionCriteria(object):
    """
    Rule Selection Criteria for DYNAMIC resource selection for a GENERIC fleet.
    Rules define what resources are members of this fleet. All resources that meet the criteria are added automatically.
    """

    #: A constant which can be used with the match_condition property of a SelectionCriteria.
    #: This constant has a value of "MATCH_ALL"
    MATCH_CONDITION_MATCH_ALL = "MATCH_ALL"

    #: A constant which can be used with the match_condition property of a SelectionCriteria.
    #: This constant has a value of "ANY"
    MATCH_CONDITION_ANY = "ANY"

    def __init__(self, **kwargs):
        """
        Initializes a new SelectionCriteria object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param match_condition:
            The value to assign to the match_condition property of this SelectionCriteria.
            Allowed values for this property are: "MATCH_ALL", "ANY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type match_condition: str

        :param rules:
            The value to assign to the rules property of this SelectionCriteria.
        :type rules: list[oci.fleet_apps_management.models.Rule]

        """
        self.swagger_types = {
            'match_condition': 'str',
            'rules': 'list[Rule]'
        }
        self.attribute_map = {
            'match_condition': 'matchCondition',
            'rules': 'rules'
        }
        self._match_condition = None
        self._rules = None

    @property
    def match_condition(self):
        """
        **[Required]** Gets the match_condition of this SelectionCriteria.
        Match condition for the rule selection.
        Include resources that match all rules or any of the rules.

        Allowed values for this property are: "MATCH_ALL", "ANY", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The match_condition of this SelectionCriteria.
        :rtype: str
        """
        return self._match_condition

    @match_condition.setter
    def match_condition(self, match_condition):
        """
        Sets the match_condition of this SelectionCriteria.
        Match condition for the rule selection.
        Include resources that match all rules or any of the rules.


        :param match_condition: The match_condition of this SelectionCriteria.
        :type: str
        """
        allowed_values = ["MATCH_ALL", "ANY"]
        if not value_allowed_none_or_none_sentinel(match_condition, allowed_values):
            match_condition = 'UNKNOWN_ENUM_VALUE'
        self._match_condition = match_condition

    @property
    def rules(self):
        """
        **[Required]** Gets the rules of this SelectionCriteria.
        Rules.


        :return: The rules of this SelectionCriteria.
        :rtype: list[oci.fleet_apps_management.models.Rule]
        """
        return self._rules

    @rules.setter
    def rules(self, rules):
        """
        Sets the rules of this SelectionCriteria.
        Rules.


        :param rules: The rules of this SelectionCriteria.
        :type: list[oci.fleet_apps_management.models.Rule]
        """
        self._rules = rules

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
