# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from .transfer_runbook_content_details import TransferRunbookContentDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TransferRunbookParUrlContentDetails(TransferRunbookContentDetails):
    """
    Details about Object Storage Bucket source.
    Restricted to the region this is called.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new TransferRunbookParUrlContentDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.TransferRunbookParUrlContentDetails.source_type` attribute
        of this class is ``PAR_URL`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source_type:
            The value to assign to the source_type property of this TransferRunbookParUrlContentDetails.
            Allowed values for this property are: "OBJECT_STORAGE_BUCKET", "PAR_URL"
        :type source_type: str

        :param url:
            The value to assign to the url property of this TransferRunbookParUrlContentDetails.
        :type url: str

        """
        self.swagger_types = {
            'source_type': 'str',
            'url': 'str'
        }
        self.attribute_map = {
            'source_type': 'sourceType',
            'url': 'url'
        }
        self._source_type = None
        self._url = None
        self._source_type = 'PAR_URL'

    @property
    def url(self):
        """
        **[Required]** Gets the url of this TransferRunbookParUrlContentDetails.
        PAR url.


        :return: The url of this TransferRunbookParUrlContentDetails.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this TransferRunbookParUrlContentDetails.
        PAR url.


        :param url: The url of this TransferRunbookParUrlContentDetails.
        :type: str
        """
        self._url = url

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
