# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ApiKeyItem(object):
    """
    The ApiKey item.
    """

    #: A constant which can be used with the state property of a ApiKeyItem.
    #: This constant has a value of "ACTIVE"
    STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the state property of a ApiKeyItem.
    #: This constant has a value of "INACTIVE"
    STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the state property of a ApiKeyItem.
    #: This constant has a value of "REVOKED"
    STATE_REVOKED = "REVOKED"

    #: A constant which can be used with the state property of a ApiKeyItem.
    #: This constant has a value of "EXPIRED"
    STATE_EXPIRED = "EXPIRED"

    #: A constant which can be used with the state property of a ApiKeyItem.
    #: This constant has a value of "DELETED"
    STATE_DELETED = "DELETED"

    def __init__(self, **kwargs):
        """
        Initializes a new ApiKeyItem object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param key:
            The value to assign to the key property of this ApiKeyItem.
        :type key: str

        :param key_name:
            The value to assign to the key_name property of this ApiKeyItem.
        :type key_name: str

        :param key_mask:
            The value to assign to the key_mask property of this ApiKeyItem.
        :type key_mask: str

        :param time_created:
            The value to assign to the time_created property of this ApiKeyItem.
        :type time_created: datetime

        :param time_expiry:
            The value to assign to the time_expiry property of this ApiKeyItem.
        :type time_expiry: datetime

        :param time_activated:
            The value to assign to the time_activated property of this ApiKeyItem.
        :type time_activated: datetime

        :param time_deactivated:
            The value to assign to the time_deactivated property of this ApiKeyItem.
        :type time_deactivated: datetime

        :param time_revoked:
            The value to assign to the time_revoked property of this ApiKeyItem.
        :type time_revoked: datetime

        :param time_last_used:
            The value to assign to the time_last_used property of this ApiKeyItem.
        :type time_last_used: datetime

        :param state:
            The value to assign to the state property of this ApiKeyItem.
            Allowed values for this property are: "ACTIVE", "INACTIVE", "REVOKED", "EXPIRED", "DELETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type state: str

        """
        self.swagger_types = {
            'key': 'str',
            'key_name': 'str',
            'key_mask': 'str',
            'time_created': 'datetime',
            'time_expiry': 'datetime',
            'time_activated': 'datetime',
            'time_deactivated': 'datetime',
            'time_revoked': 'datetime',
            'time_last_used': 'datetime',
            'state': 'str'
        }
        self.attribute_map = {
            'key': 'key',
            'key_name': 'keyName',
            'key_mask': 'keyMask',
            'time_created': 'timeCreated',
            'time_expiry': 'timeExpiry',
            'time_activated': 'timeActivated',
            'time_deactivated': 'timeDeactivated',
            'time_revoked': 'timeRevoked',
            'time_last_used': 'timeLastUsed',
            'state': 'state'
        }
        self._key = None
        self._key_name = None
        self._key_mask = None
        self._time_created = None
        self._time_expiry = None
        self._time_activated = None
        self._time_deactivated = None
        self._time_revoked = None
        self._time_last_used = None
        self._state = None

    @property
    def key(self):
        """
        Gets the key of this ApiKeyItem.
        The key.


        :return: The key of this ApiKeyItem.
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """
        Sets the key of this ApiKeyItem.
        The key.


        :param key: The key of this ApiKeyItem.
        :type: str
        """
        self._key = key

    @property
    def key_name(self):
        """
        **[Required]** Gets the key_name of this ApiKeyItem.
        The key name.


        :return: The key_name of this ApiKeyItem.
        :rtype: str
        """
        return self._key_name

    @key_name.setter
    def key_name(self, key_name):
        """
        Sets the key_name of this ApiKeyItem.
        The key name.


        :param key_name: The key_name of this ApiKeyItem.
        :type: str
        """
        self._key_name = key_name

    @property
    def key_mask(self):
        """
        **[Required]** Gets the key_mask of this ApiKeyItem.
        The masked key.


        :return: The key_mask of this ApiKeyItem.
        :rtype: str
        """
        return self._key_mask

    @key_mask.setter
    def key_mask(self, key_mask):
        """
        Sets the key_mask of this ApiKeyItem.
        The masked key.


        :param key_mask: The key_mask of this ApiKeyItem.
        :type: str
        """
        self._key_mask = key_mask

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this ApiKeyItem.
        The date and time that the key was created in the format of an RFC3339 datetime string.


        :return: The time_created of this ApiKeyItem.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ApiKeyItem.
        The date and time that the key was created in the format of an RFC3339 datetime string.


        :param time_created: The time_created of this ApiKeyItem.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_expiry(self):
        """
        **[Required]** Gets the time_expiry of this ApiKeyItem.
        The date and time when the key would be expired, if not provided it would be 90 days, in the format defined by RFC 3339.


        :return: The time_expiry of this ApiKeyItem.
        :rtype: datetime
        """
        return self._time_expiry

    @time_expiry.setter
    def time_expiry(self, time_expiry):
        """
        Sets the time_expiry of this ApiKeyItem.
        The date and time when the key would be expired, if not provided it would be 90 days, in the format defined by RFC 3339.


        :param time_expiry: The time_expiry of this ApiKeyItem.
        :type: datetime
        """
        self._time_expiry = time_expiry

    @property
    def time_activated(self):
        """
        Gets the time_activated of this ApiKeyItem.
        The date and time that the key is activated in the format of an RFC3339 datetime string.


        :return: The time_activated of this ApiKeyItem.
        :rtype: datetime
        """
        return self._time_activated

    @time_activated.setter
    def time_activated(self, time_activated):
        """
        Sets the time_activated of this ApiKeyItem.
        The date and time that the key is activated in the format of an RFC3339 datetime string.


        :param time_activated: The time_activated of this ApiKeyItem.
        :type: datetime
        """
        self._time_activated = time_activated

    @property
    def time_deactivated(self):
        """
        Gets the time_deactivated of this ApiKeyItem.
        The date and time that the key is deactivated in the format of an RFC3339 datetime string.


        :return: The time_deactivated of this ApiKeyItem.
        :rtype: datetime
        """
        return self._time_deactivated

    @time_deactivated.setter
    def time_deactivated(self, time_deactivated):
        """
        Sets the time_deactivated of this ApiKeyItem.
        The date and time that the key is deactivated in the format of an RFC3339 datetime string.


        :param time_deactivated: The time_deactivated of this ApiKeyItem.
        :type: datetime
        """
        self._time_deactivated = time_deactivated

    @property
    def time_revoked(self):
        """
        Gets the time_revoked of this ApiKeyItem.
        The date and time that the key is revoked in the format of an RFC3339 datetime string.


        :return: The time_revoked of this ApiKeyItem.
        :rtype: datetime
        """
        return self._time_revoked

    @time_revoked.setter
    def time_revoked(self, time_revoked):
        """
        Sets the time_revoked of this ApiKeyItem.
        The date and time that the key is revoked in the format of an RFC3339 datetime string.


        :param time_revoked: The time_revoked of this ApiKeyItem.
        :type: datetime
        """
        self._time_revoked = time_revoked

    @property
    def time_last_used(self):
        """
        Gets the time_last_used of this ApiKeyItem.
        The date and time that the key is last used in the format of an RFC3339 datetime string.


        :return: The time_last_used of this ApiKeyItem.
        :rtype: datetime
        """
        return self._time_last_used

    @time_last_used.setter
    def time_last_used(self, time_last_used):
        """
        Sets the time_last_used of this ApiKeyItem.
        The date and time that the key is last used in the format of an RFC3339 datetime string.


        :param time_last_used: The time_last_used of this ApiKeyItem.
        :type: datetime
        """
        self._time_last_used = time_last_used

    @property
    def state(self):
        """
        **[Required]** Gets the state of this ApiKeyItem.
        The current state of the API key item.

        Allowed values for this property are: "ACTIVE", "INACTIVE", "REVOKED", "EXPIRED", "DELETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The state of this ApiKeyItem.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this ApiKeyItem.
        The current state of the API key item.


        :param state: The state of this ApiKeyItem.
        :type: str
        """
        allowed_values = ["ACTIVE", "INACTIVE", "REVOKED", "EXPIRED", "DELETED"]
        if not value_allowed_none_or_none_sentinel(state, allowed_values):
            state = 'UNKNOWN_ENUM_VALUE'
        self._state = state

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
