# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130

from .model_metrics import ModelMetrics
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ChatModelMetrics(ModelMetrics):
    """
    The chat model metrics of the fine-tuning process.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ChatModelMetrics object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai.models.ChatModelMetrics.model_metrics_type` attribute
        of this class is ``CHAT_MODEL_METRICS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param model_metrics_type:
            The value to assign to the model_metrics_type property of this ChatModelMetrics.
            Allowed values for this property are: "TEXT_GENERATION_MODEL_METRICS", "CHAT_MODEL_METRICS"
        :type model_metrics_type: str

        :param final_accuracy:
            The value to assign to the final_accuracy property of this ChatModelMetrics.
        :type final_accuracy: float

        :param final_loss:
            The value to assign to the final_loss property of this ChatModelMetrics.
        :type final_loss: float

        """
        self.swagger_types = {
            'model_metrics_type': 'str',
            'final_accuracy': 'float',
            'final_loss': 'float'
        }
        self.attribute_map = {
            'model_metrics_type': 'modelMetricsType',
            'final_accuracy': 'finalAccuracy',
            'final_loss': 'finalLoss'
        }
        self._model_metrics_type = None
        self._final_accuracy = None
        self._final_loss = None
        self._model_metrics_type = 'CHAT_MODEL_METRICS'

    @property
    def final_accuracy(self):
        """
        Gets the final_accuracy of this ChatModelMetrics.
        Fine-tuned model accuracy.


        :return: The final_accuracy of this ChatModelMetrics.
        :rtype: float
        """
        return self._final_accuracy

    @final_accuracy.setter
    def final_accuracy(self, final_accuracy):
        """
        Sets the final_accuracy of this ChatModelMetrics.
        Fine-tuned model accuracy.


        :param final_accuracy: The final_accuracy of this ChatModelMetrics.
        :type: float
        """
        self._final_accuracy = final_accuracy

    @property
    def final_loss(self):
        """
        Gets the final_loss of this ChatModelMetrics.
        Fine-tuned model loss.


        :return: The final_loss of this ChatModelMetrics.
        :rtype: float
        """
        return self._final_loss

    @final_loss.setter
    def final_loss(self, final_loss):
        """
        Sets the final_loss of this ChatModelMetrics.
        Fine-tuned model loss.


        :param final_loss: The final_loss of this ChatModelMetrics.
        :type: float
        """
        self._final_loss = final_loss

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
