# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateGenerativeAiPrivateEndpointDetails(object):
    """
    The details required to create a Generative AI private endpoint.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateGenerativeAiPrivateEndpointDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateGenerativeAiPrivateEndpointDetails.
        :type compartment_id: str

        :param subnet_id:
            The value to assign to the subnet_id property of this CreateGenerativeAiPrivateEndpointDetails.
        :type subnet_id: str

        :param description:
            The value to assign to the description property of this CreateGenerativeAiPrivateEndpointDetails.
        :type description: str

        :param display_name:
            The value to assign to the display_name property of this CreateGenerativeAiPrivateEndpointDetails.
        :type display_name: str

        :param dns_prefix:
            The value to assign to the dns_prefix property of this CreateGenerativeAiPrivateEndpointDetails.
        :type dns_prefix: str

        :param nsg_ids:
            The value to assign to the nsg_ids property of this CreateGenerativeAiPrivateEndpointDetails.
        :type nsg_ids: list[str]

        :param is_allow_on_demand:
            The value to assign to the is_allow_on_demand property of this CreateGenerativeAiPrivateEndpointDetails.
        :type is_allow_on_demand: bool

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateGenerativeAiPrivateEndpointDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateGenerativeAiPrivateEndpointDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'subnet_id': 'str',
            'description': 'str',
            'display_name': 'str',
            'dns_prefix': 'str',
            'nsg_ids': 'list[str]',
            'is_allow_on_demand': 'bool',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'subnet_id': 'subnetId',
            'description': 'description',
            'display_name': 'displayName',
            'dns_prefix': 'dnsPrefix',
            'nsg_ids': 'nsgIds',
            'is_allow_on_demand': 'isAllowOnDemand',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._compartment_id = None
        self._subnet_id = None
        self._description = None
        self._display_name = None
        self._dns_prefix = None
        self._nsg_ids = None
        self._is_allow_on_demand = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateGenerativeAiPrivateEndpointDetails.
        The OCID of the compartment where the private endpoint is created.


        :return: The compartment_id of this CreateGenerativeAiPrivateEndpointDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateGenerativeAiPrivateEndpointDetails.
        The OCID of the compartment where the private endpoint is created.


        :param compartment_id: The compartment_id of this CreateGenerativeAiPrivateEndpointDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def subnet_id(self):
        """
        **[Required]** Gets the subnet_id of this CreateGenerativeAiPrivateEndpointDetails.
        The OCID of the customer's subnet where the private endpoint VNIC will reside.


        :return: The subnet_id of this CreateGenerativeAiPrivateEndpointDetails.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this CreateGenerativeAiPrivateEndpointDetails.
        The OCID of the customer's subnet where the private endpoint VNIC will reside.


        :param subnet_id: The subnet_id of this CreateGenerativeAiPrivateEndpointDetails.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def description(self):
        """
        Gets the description of this CreateGenerativeAiPrivateEndpointDetails.
        A description of this private endpoint.


        :return: The description of this CreateGenerativeAiPrivateEndpointDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateGenerativeAiPrivateEndpointDetails.
        A description of this private endpoint.


        :param description: The description of this CreateGenerativeAiPrivateEndpointDetails.
        :type: str
        """
        self._description = description

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateGenerativeAiPrivateEndpointDetails.
        A user friendly name. It doesn't have to be unique. Avoid entering confidential information.


        :return: The display_name of this CreateGenerativeAiPrivateEndpointDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateGenerativeAiPrivateEndpointDetails.
        A user friendly name. It doesn't have to be unique. Avoid entering confidential information.


        :param display_name: The display_name of this CreateGenerativeAiPrivateEndpointDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def dns_prefix(self):
        """
        **[Required]** Gets the dns_prefix of this CreateGenerativeAiPrivateEndpointDetails.
        dnsPrefix of the private endpoint FQDN.


        :return: The dns_prefix of this CreateGenerativeAiPrivateEndpointDetails.
        :rtype: str
        """
        return self._dns_prefix

    @dns_prefix.setter
    def dns_prefix(self, dns_prefix):
        """
        Sets the dns_prefix of this CreateGenerativeAiPrivateEndpointDetails.
        dnsPrefix of the private endpoint FQDN.


        :param dns_prefix: The dns_prefix of this CreateGenerativeAiPrivateEndpointDetails.
        :type: str
        """
        self._dns_prefix = dns_prefix

    @property
    def nsg_ids(self):
        """
        Gets the nsg_ids of this CreateGenerativeAiPrivateEndpointDetails.
        A list of the OCIDs of the network security groups (NSGs) to add the private endpoint's VNIC to.


        :return: The nsg_ids of this CreateGenerativeAiPrivateEndpointDetails.
        :rtype: list[str]
        """
        return self._nsg_ids

    @nsg_ids.setter
    def nsg_ids(self, nsg_ids):
        """
        Sets the nsg_ids of this CreateGenerativeAiPrivateEndpointDetails.
        A list of the OCIDs of the network security groups (NSGs) to add the private endpoint's VNIC to.


        :param nsg_ids: The nsg_ids of this CreateGenerativeAiPrivateEndpointDetails.
        :type: list[str]
        """
        self._nsg_ids = nsg_ids

    @property
    def is_allow_on_demand(self):
        """
        Gets the is_allow_on_demand of this CreateGenerativeAiPrivateEndpointDetails.
        Flag that allows access to on-demand models using this private endpoint.


        :return: The is_allow_on_demand of this CreateGenerativeAiPrivateEndpointDetails.
        :rtype: bool
        """
        return self._is_allow_on_demand

    @is_allow_on_demand.setter
    def is_allow_on_demand(self, is_allow_on_demand):
        """
        Sets the is_allow_on_demand of this CreateGenerativeAiPrivateEndpointDetails.
        Flag that allows access to on-demand models using this private endpoint.


        :param is_allow_on_demand: The is_allow_on_demand of this CreateGenerativeAiPrivateEndpointDetails.
        :type: bool
        """
        self._is_allow_on_demand = is_allow_on_demand

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateGenerativeAiPrivateEndpointDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateGenerativeAiPrivateEndpointDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateGenerativeAiPrivateEndpointDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateGenerativeAiPrivateEndpointDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateGenerativeAiPrivateEndpointDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateGenerativeAiPrivateEndpointDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateGenerativeAiPrivateEndpointDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateGenerativeAiPrivateEndpointDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
