# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class KeyDetails(object):
    """
    The data to create/renew an API key item.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new KeyDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param key_name:
            The value to assign to the key_name property of this KeyDetails.
        :type key_name: str

        :param time_expiry:
            The value to assign to the time_expiry property of this KeyDetails.
        :type time_expiry: datetime

        """
        self.swagger_types = {
            'key_name': 'str',
            'time_expiry': 'datetime'
        }
        self.attribute_map = {
            'key_name': 'keyName',
            'time_expiry': 'timeExpiry'
        }
        self._key_name = None
        self._time_expiry = None

    @property
    def key_name(self):
        """
        **[Required]** Gets the key_name of this KeyDetails.
        The key to renew.


        :return: The key_name of this KeyDetails.
        :rtype: str
        """
        return self._key_name

    @key_name.setter
    def key_name(self, key_name):
        """
        Sets the key_name of this KeyDetails.
        The key to renew.


        :param key_name: The key_name of this KeyDetails.
        :type: str
        """
        self._key_name = key_name

    @property
    def time_expiry(self):
        """
        **[Required]** Gets the time_expiry of this KeyDetails.
        The date and time when the key would be expired, if not provided it would be 90 days, in the format defined by RFC 3339.


        :return: The time_expiry of this KeyDetails.
        :rtype: datetime
        """
        return self._time_expiry

    @time_expiry.setter
    def time_expiry(self, time_expiry):
        """
        Sets the time_expiry of this KeyDetails.
        The date and time when the key would be expired, if not provided it would be 90 days, in the format defined by RFC 3339.


        :param time_expiry: The time_expiry of this KeyDetails.
        :type: datetime
        """
        self._time_expiry = time_expiry

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
